/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProjectFrameworkImpl;
import org.eclipse.wst.common.project.facet.core.internal.Group;
import org.eclipse.wst.common.project.facet.core.internal.ProblemLog;
import org.eclipse.wst.common.project.facet.core.util.internal.PluginUtil;

public final class ProjectFacetGroupsExtensionPoint {
    private static final String GROUPS_EXTENSION_POINT_ID = "groups";
    private static final String FACETS_EXTENSION_POINT_ID = "facets";
    private static final String EL_GROUP = "group";
    private static final String EL_LABEL = "label";
    private static final String EL_DESCRIPTION = "description";
    private static final String EL_INCLUDE = "include";
    private static final String EL_MEMBERS = "members";
    private static final String EL_PROJECT_FACET_VERSION = "project-facet-version";
    private static final String EL_GROUP_MEMBER = "group-member";
    private static final String ATTR_ID = "id";
    private static final String ATTR_GROUP = "group";
    private static final String ATTR_FACET = "facet";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_VERSIONS = "versions";

    public static void processExtensions(FacetedProjectFrameworkImpl framework) {
        for (IConfigurationElement element : PluginUtil.getTopLevelElements(PluginUtil.findExtensions("org.eclipse.wst.common.project.facet.core", GROUPS_EXTENSION_POINT_ID))) {
            try {
                String elname = element.getName();
                if (elname.equals("group")) {
                    String id = PluginUtil.findRequiredAttribute(element, ATTR_ID);
                    String label = PluginUtil.getElementValue(PluginUtil.findRequiredElement(element, EL_LABEL), null);
                    String description = PluginUtil.getElementValue(PluginUtil.findOptionalElement(element, EL_DESCRIPTION), "");
                    Group group = ProjectFacetGroupsExtensionPoint.findOrCreateGroup(framework, id);
                    group.setLabel(label);
                    group.setDescription(description);
                    ProjectFacetGroupsExtensionPoint.processIncludeDirectives(framework, group, element);
                    continue;
                }
                if (!elname.equals(EL_MEMBERS)) continue;
                String gid = PluginUtil.findRequiredAttribute(element, "group");
                Group group = ProjectFacetGroupsExtensionPoint.findOrCreateGroup(framework, gid);
                ProjectFacetGroupsExtensionPoint.processIncludeDirectives(framework, group, element);
            }
            catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
        }
        for (IConfigurationElement element : PluginUtil.getTopLevelElements(PluginUtil.findExtensions("org.eclipse.wst.common.project.facet.core", FACETS_EXTENSION_POINT_ID))) {
            String fid;
            IConfigurationElement[] groupMemberElements;
            if (!element.getName().equals(EL_PROJECT_FACET_VERSION) || (groupMemberElements = element.getChildren(EL_GROUP_MEMBER)).length <= 0 || (fid = element.getAttribute(ATTR_FACET)) == null || !framework.isProjectFacetDefined(fid)) continue;
            IProjectFacet f = framework.getProjectFacet(fid);
            String version = element.getAttribute(ATTR_VERSION);
            if (version == null || !f.hasVersion(version)) continue;
            IProjectFacetVersion fv = f.getVersion(version);
            IConfigurationElement[] iConfigurationElementArray = groupMemberElements;
            int n = groupMemberElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement groupMemberElement = iConfigurationElementArray[n2];
                try {
                    String gid = PluginUtil.findRequiredAttribute(groupMemberElement, ATTR_ID);
                    ProjectFacetGroupsExtensionPoint.findOrCreateGroup(framework, gid).addMember(fv);
                }
                catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
                ++n2;
            }
        }
        for (IConfigurationElement element : PluginUtil.getTopLevelElements(PluginUtil.findExtensions("org.eclipse.wst.common.project.facet.core", FACETS_EXTENSION_POINT_ID))) {
            if (!element.getName().equals("group")) continue;
            try {
                String id = PluginUtil.findRequiredAttribute(element, ATTR_ID);
                String label = PluginUtil.getElementValue(PluginUtil.findRequiredElement(element, EL_LABEL), null);
                String description = PluginUtil.getElementValue(PluginUtil.findOptionalElement(element, EL_DESCRIPTION), "");
                Group group = ProjectFacetGroupsExtensionPoint.findOrCreateGroup(framework, id);
                group.setLabel(label);
                group.setDescription(description);
            }
            catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
        }
    }

    private static void processIncludeDirectives(FacetedProjectFrameworkImpl framework, Group group, IConfigurationElement context) {
        String bundleId = context.getContributor().getName();
        IConfigurationElement[] iConfigurationElementArray = context.getChildren(EL_INCLUDE);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                String fid = PluginUtil.findRequiredAttribute(element, ATTR_FACET);
                String versions = element.getAttribute(ATTR_VERSIONS);
                if (framework.isProjectFacetDefined(fid)) {
                    IProjectFacet f = framework.getProjectFacet(fid);
                    group.addMembers(versions == null ? f.getVersions() : f.getVersions(versions));
                } else {
                    ProblemLog.reportMissingFacet(fid, bundleId);
                }
            }
            catch (PluginUtil.InvalidExtensionException invalidExtensionException) {
            }
            catch (CoreException e) {
                FacetCorePlugin.log((Exception)((Object)e));
            }
            ++n2;
        }
    }

    private static Group findOrCreateGroup(FacetedProjectFrameworkImpl framework, String id) {
        Group group;
        if (framework.isGroupDefined(id)) {
            group = (Group)framework.getGroup(id);
        } else {
            group = new Group();
            group.setId(id);
            framework.addGroup(group);
        }
        return group;
    }

    public static final class Resources
    extends NLS {
        public static String invalidEventType;

        static {
            Resources.initializeMessages((String)ProjectFacetGroupsExtensionPoint.class.getName(), Resources.class);
        }
    }
}

