/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.serializer.impl;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.ide.serializer.IChangeSerializer;
import org.eclipse.xtext.ide.serializer.IEmfResourceChange;
import org.eclipse.xtext.ide.serializer.hooks.IResourceSnapshot;
import org.eclipse.xtext.ide.serializer.impl.EObjectDescriptionDeltaProvider;
import org.eclipse.xtext.ide.serializer.impl.EObjectSnapshotProvider;
import org.eclipse.xtext.ide.serializer.impl.EmfResourceChange;
import org.eclipse.xtext.ide.serializer.impl.RecordingResourceUpdater;
import org.eclipse.xtext.util.IAcceptor;

public class RecordingEmfResourceUpdater
extends RecordingResourceUpdater {
    private IChangeSerializer serializer;
    private IResourceSnapshot snapshot;
    @Inject
    private EObjectSnapshotProvider snapshotProvider;

    @Override
    public void applyChange(EObjectDescriptionDeltaProvider.Deltas deltas, IAcceptor<IEmfResourceChange> changeAcceptor) {
        EmfResourceChange change = new EmfResourceChange(this.snapshot.getResource(), this.snapshot.getURI());
        changeAcceptor.accept((Object)change);
    }

    public void beginRecording(IChangeSerializer serializer, Resource resource) {
        this.serializer = serializer;
        this.snapshot = this.snapshotProvider.createResourceSnapshot(resource, serializer.isUpdateCrossReferences());
        EcoreUtil.resolveAll((Resource)resource);
    }

    @Override
    public Resource getResource() {
        return this.snapshot.getResource();
    }

    public IChangeSerializer getSerializer() {
        return this.serializer;
    }

    @Override
    public IResourceSnapshot getSnapshot() {
        return this.snapshot;
    }

    public String toString() {
        URI newURI;
        StringBuilder result = new StringBuilder(this.getClass().getSimpleName());
        URI oldURI = this.getSnapshot().getURI();
        if (oldURI.equals(newURI = this.getResource().getURI())) {
            result.append(" " + oldURI);
        } else {
            result.append(" " + oldURI + " -> " + newURI);
        }
        return result.toString();
    }

    @Override
    public void unload() {
    }
}

