/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xtext.resourceset;

import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

class StandardResourceLocator
extends ResourceSetImpl.ResourceLocator {
    public StandardResourceLocator(ResourceSetImpl resourceSet) {
        super(resourceSet);
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        return this.basicGetResource(uri, loadOnDemand);
    }

    protected Resource basicGetResource(URI uri, boolean loadOnDemand) {
        Resource resource;
        Map map = this.resourceSet.getURIResourceMap();
        if (map != null && (resource = (Resource)map.get(uri)) != null) {
            if (loadOnDemand && !resource.isLoaded()) {
                this.demandLoadHelper(resource);
            }
            return resource;
        }
        URIConverter theURIConverter = this.resourceSet.getURIConverter();
        URI normalizedURI = theURIConverter.normalize(uri);
        for (Resource resource2 : this.resourceSet.getResources()) {
            if (!theURIConverter.normalize(resource2.getURI()).equals(normalizedURI)) continue;
            if (loadOnDemand && !resource2.isLoaded()) {
                this.demandLoadHelper(resource2);
            }
            if (map != null) {
                map.put(uri, resource2);
            }
            return resource2;
        }
        Resource delegatedResource = this.delegatedGetResource(uri, loadOnDemand);
        if (delegatedResource != null) {
            if (map != null) {
                map.put(uri, delegatedResource);
            }
            return delegatedResource;
        }
        if (loadOnDemand) {
            Resource resource3 = this.demandCreateResource(uri);
            if (resource3 == null) {
                throw new RuntimeException("Cannot create a resource for '" + uri + "'; a registered resource factory is needed");
            }
            this.demandLoadHelper(resource3);
            if (map != null) {
                map.put(uri, resource3);
            }
            return resource3;
        }
        return null;
    }
}

