/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server;

import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import java.util.concurrent.TimeUnit;
import org.eclipse.xtext.util.CancelIndicator;

public class BufferedCancelIndicator
implements CancelIndicator {
    private final CancelIndicator delegate;
    private final long ONE_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private final Ticker clock;
    private long canceledSince;

    public BufferedCancelIndicator(CancelIndicator delegate) {
        this(delegate, Ticker.systemTicker());
    }

    public BufferedCancelIndicator(CancelIndicator delegate, Ticker clock) {
        this.delegate = (CancelIndicator)Preconditions.checkNotNull((Object)delegate);
        this.clock = (Ticker)Preconditions.checkNotNull((Object)clock);
    }

    public boolean isCanceled() {
        if (this.canceledSince == 0L && this.delegate.isCanceled()) {
            this.canceledSince = this.clock.read();
            return false;
        }
        return this.canceledSince != 0L && this.clock.read() > this.canceledSince + this.ONE_SECOND;
    }
}

