/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.transpiler.TranspilerState;
import org.eclipse.n4js.transpiler.im.ImFactory;
import org.eclipse.n4js.transpiler.im.ImPackage;
import org.eclipse.n4js.transpiler.im.ReferencingElement_IM;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryIMOnly;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryInternal;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.transpiler.im.VersionedNamedImportSpecifier_IM;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.ModuleNamespaceVirtualType;
import org.eclipse.n4js.ts.types.NameAndAccess;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;

public class SymbolTableManagement {
    public static SymbolTableEntryOriginal createSymbolTableEntryOriginal(TranspilerState state, IdentifiableElement originalTarget) {
        if (originalTarget == null) {
            throw new IllegalArgumentException("original target may not be null");
        }
        SymbolTableEntryOriginal newEntry = ImFactory.eINSTANCE.createSymbolTableEntryOriginal();
        newEntry.setName(originalTarget.getName());
        newEntry.setOriginalTarget(originalTarget);
        if (originalTarget instanceof NamedElement) {
            EList<NamedElement> _elementsOfThisName = newEntry.getElementsOfThisName();
            _elementsOfThisName.add((Object)((NamedElement)originalTarget));
        }
        SymbolTableManagement.addOriginal(state, newEntry);
        return newEntry;
    }

    public static void addOriginal(TranspilerState state, SymbolTableEntryOriginal steOriginal) {
        SymbolTableManagement.addOriginal(state.steCache, steOriginal);
    }

    public static void addOriginal(TranspilerState.STECache steCache, SymbolTableEntryOriginal steOriginal) {
        SymbolTableEntryOriginal old = steCache.mapOriginal.put(steOriginal.getOriginalTarget(), steOriginal);
        if (old != null) {
            throw new IllegalStateException("It is not allowed to register more then one STEOriginal for the same original Target. Already had: " + old);
        }
        steCache.im.getSymbolTable().getEntries().add((Object)steOriginal);
        SymbolTableManagement.inverseMap(steCache, steOriginal);
    }

    private static void inverseMap(TranspilerState.STECache steManager, SymbolTableEntryOriginal steOriginal) {
        Consumer<NamedElement> _function = ele -> sTECache.mapNamedElement_2_STE.put((NamedElement)ele, steOriginal);
        steOriginal.getElementsOfThisName().forEach(_function);
    }

    public static SymbolTableEntryIMOnly createSymbolTableEntryIMOnly(TranspilerState state, NamedElement elementInIM) {
        if (elementInIM == null) {
            throw new IllegalArgumentException("element in intermediate model may not be null");
        }
        SymbolTableEntryIMOnly newEntry = ImFactory.eINSTANCE.createSymbolTableEntryIMOnly();
        newEntry.setName(elementInIM.getName());
        EList<NamedElement> _elementsOfThisName = newEntry.getElementsOfThisName();
        _elementsOfThisName.add((Object)elementInIM);
        SymbolTableManagement.addIMOnly(state, newEntry);
        return newEntry;
    }

    public static SymbolTableEntryInternal createSymbolTableEntryInternal(TranspilerState state, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name may not be null");
        }
        SymbolTableEntryInternal newEntry = ImFactory.eINSTANCE.createSymbolTableEntryInternal();
        newEntry.setName(name);
        SymbolTableManagement.addInteral(state, newEntry);
        return newEntry;
    }

    private static void addInteral(TranspilerState state, SymbolTableEntryInternal ste) {
        SymbolTableEntryInternal old = state.steCache.mapInternal.put(ste.getName(), ste);
        if (old != null) {
            throw new IllegalStateException("It is not allowed to put the same SymbolTableEntryInternal twice into the Symboltable " + old);
        }
        state.im.getSymbolTable().getEntries().add((Object)ste);
    }

    public static SymbolTableEntryOriginal getSymbolTableEntryOriginal(TranspilerState state, IdentifiableElement originalTarget, boolean create) {
        if (originalTarget == null) {
            throw new IllegalArgumentException("original target may not be null");
        }
        SymbolTableEntryOriginal existingEntry = SymbolTableManagement.getSteOriginal(state, originalTarget);
        if (existingEntry != null) {
            return existingEntry;
        }
        if (create) {
            return SymbolTableManagement.createSymbolTableEntryOriginal(state, originalTarget);
        }
        return null;
    }

    public static SymbolTableEntryOriginal getSymbolTableEntryForMember(TranspilerState state, TClassifier type, String memberName, boolean writeAccess, boolean staticAccess, boolean create) {
        if (type == null || memberName == null || memberName.isEmpty()) {
            throw new IllegalArgumentException("type may not be null and memberName may not be null or empty");
        }
        TMember m = type.findOwnedMember(memberName, writeAccess, staticAccess);
        if (m == null) {
            NameAndAccess nameAndAccess = new NameAndAccess(memberName, writeAccess, staticAccess);
            throw new IllegalArgumentException("no such member found in given type: " + nameAndAccess);
        }
        return SymbolTableManagement.getSymbolTableEntryOriginal(state, (IdentifiableElement)m, create);
    }

    public static SymbolTableEntryInternal getSymbolTableEntryInternal(TranspilerState state, String name, boolean create) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name may not be null or empty");
        }
        SymbolTableEntryInternal existingEntry = SymbolTableManagement.getSteInternal(state, name);
        if (existingEntry != null) {
            return existingEntry;
        }
        if (create) {
            return SymbolTableManagement.createSymbolTableEntryInternal(state, name);
        }
        return null;
    }

    public static SymbolTableEntry findSymbolTableEntryForElement(TranspilerState state, NamedElement elementInIM, boolean create) {
        if (elementInIM == null) {
            throw new IllegalArgumentException("element in intermediate model may not be null");
        }
        SymbolTableEntry existingEntry = SymbolTableManagement.byElementsOfThisName(state, elementInIM);
        if (existingEntry != null) {
            return existingEntry;
        }
        if (create) {
            return SymbolTableManagement.createSymbolTableEntryIMOnly(state, elementInIM);
        }
        return null;
    }

    public static SymbolTableEntryOriginal findSymbolTableEntryForNamespaceImport(TranspilerState state, NamespaceImportSpecifier importspec) {
        Predicate<SymbolTableEntryOriginal> _function = it -> {
            ImportSpecifier _importSpecifier = it.getImportSpecifier();
            return _importSpecifier == importspec;
        };
        Predicate<SymbolTableEntryOriginal> _function_1 = it -> {
            IdentifiableElement _originalTarget = it.getOriginalTarget();
            return _originalTarget instanceof ModuleNamespaceVirtualType;
        };
        return state.steCache.mapOriginal.values().parallelStream().filter(_function).filter(_function_1).findAny().orElse(null);
    }

    public static void rewireSymbolTable(TranspilerState state, EObject from, EObject to) {
        if (!SymbolTableManagement.requiresRewiringOfSymbolTable(from) && !SymbolTableManagement.requiresRewiringOfSymbolTable(to)) {
            return;
        }
        if (from instanceof ReferencingElement_IM && to instanceof ReferencingElement_IM) {
            EReference eRefThatMightPointToOriginal = ImPackage.eINSTANCE.getSymbolTableEntry_ReferencingElements();
            Consumer<SymbolTableEntry> _function = it -> SymbolTableManagement.replaceInEReference(it, eRefThatMightPointToOriginal, from, to);
            state.im.getSymbolTable().getEntries().parallelStream().forEach(_function);
        } else if (from instanceof ImportSpecifier && to instanceof ImportSpecifier) {
            EReference eRefThatMightPointToOriginal_1 = ImPackage.eINSTANCE.getSymbolTableEntryOriginal_ImportSpecifier();
            Predicate<SymbolTableEntry> _function_1 = it -> it instanceof SymbolTableEntryOriginal;
            Consumer<SymbolTableEntry> _function_2 = it -> SymbolTableManagement.replaceInEReference(it, eRefThatMightPointToOriginal_1, from, to);
            state.im.getSymbolTable().getEntries().parallelStream().filter(_function_1).forEach(_function_2);
        } else if (from instanceof NamedElement && to instanceof NamedElement) {
            EReference eRefThatMightPointToOriginal_2 = ImPackage.eINSTANCE.getSymbolTableEntry_ElementsOfThisName();
            SymbolTableEntry steFrom = SymbolTableManagement.byElementsOfThisName(state, (NamedElement)from);
            if (steFrom != null) {
                SymbolTableManagement.replaceInEReference(steFrom, eRefThatMightPointToOriginal_2, from, to);
                SymbolTableManagement.replacedElementOfThisName(state, steFrom, (NamedElement)from, (NamedElement)to);
            }
        } else {
            String _name = from.eClass().getName();
            String _plus = "rewiring symbol table entries from type " + _name;
            String _plus_1 = String.valueOf(_plus) + " to type ";
            String _name_1 = to.eClass().getName();
            String _plus_2 = String.valueOf(_plus_1) + _name_1;
            String _plus_3 = String.valueOf(_plus_2) + " is not supported yet";
            throw new IllegalArgumentException(_plus_3);
        }
    }

    private static boolean requiresRewiringOfSymbolTable(EObject obj) {
        return obj instanceof ReferencingElement_IM || obj instanceof ImportSpecifier || obj instanceof NamedElement;
    }

    private static <T extends EObject, TN extends T> void replaceInEReference(EObject obj, EReference eRef, T original, TN replacement) {
        boolean _isMany = eRef.isMany();
        if (_isMany) {
            Object _eGet = obj.eGet((EStructuralFeature)eRef);
            EList l = (EList)_eGet;
            int _size = l.size();
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
            for (Integer idx : _doubleDotLessThan) {
                boolean _tripleEquals;
                Object _get = l.get(idx.intValue());
                boolean bl = _tripleEquals = _get == original;
                if (!_tripleEquals) continue;
                l.set(idx.intValue(), replacement);
            }
        } else {
            boolean _tripleEquals_1;
            Object _eGet_1 = obj.eGet((EStructuralFeature)eRef);
            boolean bl = _tripleEquals_1 = _eGet_1 == original;
            if (_tripleEquals_1) {
                obj.eSet((EStructuralFeature)eRef, replacement);
            }
        }
    }

    public static void addIMOnly(TranspilerState state, SymbolTableEntryIMOnly only) {
        boolean _tripleNotEquals;
        int _size = only.getElementsOfThisName().size();
        boolean bl = _tripleNotEquals = _size != 1;
        if (_tripleNotEquals) {
            int _size_1 = only.getElementsOfThisName().size();
            String _plus = "got a STEImOnly with elmentsOfThisName != 1 : " + Integer.valueOf(_size_1);
            throw new IllegalArgumentException(_plus);
        }
        SymbolTableEntry old = state.steCache.mapNamedElement_2_STE.put((NamedElement)only.getElementsOfThisName().get(0), only);
        if (old != null) {
            NamedElement _get = (NamedElement)only.getElementsOfThisName().get(0);
            String _plus_1 = "tries to install STEImOnly but already had one for the NamedElmeent = " + _get;
            throw new IllegalStateException(_plus_1);
        }
        state.im.getSymbolTable().getEntries().add((Object)only);
    }

    public static SymbolTableEntryOriginal getSteOriginal(TranspilerState state, IdentifiableElement element) {
        return state.steCache.mapOriginal.get(element);
    }

    public static SymbolTableEntryInternal getSteInternal(TranspilerState state, String name) {
        return state.steCache.mapInternal.get(name);
    }

    public static SymbolTableEntry byElementsOfThisName(TranspilerState state, NamedElement elementInIM) {
        SymbolTableEntry lookup = state.steCache.mapNamedElement_2_STE.get(elementInIM);
        if (lookup != null) {
            boolean _contains = lookup.getElementsOfThisName().contains((Object)elementInIM);
            if (_contains) {
                return lookup;
            }
            throw new IllegalStateException("Did find STE by NamedElement which is not contained in the list STE.elementsOfThisName. elementInIM=" + elementInIM + "  found wrong STE=" + lookup);
        }
        return null;
    }

    public static void replacedElementOfThisName(TranspilerState state, SymbolTableEntry entry, NamedElement from, NamedElement to) {
        boolean _notEquals;
        SymbolTableEntry steRegisteredWithFrom = state.steCache.mapNamedElement_2_STE.get(from);
        boolean bl = _notEquals = !Objects.equal((Object)steRegisteredWithFrom, (Object)entry);
        if (_notEquals) {
            throw new IllegalArgumentException("This method must be called directly after the replacement and only once.Expected from=" + from + " to be related to entry=" + entry + " in mapNamedElement_2_STE but found: " + steRegisteredWithFrom);
        }
        state.steCache.mapNamedElement_2_STE.remove(from);
        state.steCache.mapNamedElement_2_STE.put(to, entry);
    }

    public static SymbolTableEntryOriginal findSymbolTableEntryForNamedImport(TranspilerState state, NamedImportSpecifier importspec) {
        Predicate<SymbolTableEntryOriginal> _function = it -> {
            ImportSpecifier _importSpecifier = it.getImportSpecifier();
            return Objects.equal((Object)_importSpecifier, (Object)importspec);
        };
        return state.steCache.mapOriginal.values().parallelStream().filter(_function).findAny().orElse(null);
    }

    public static Collection<SymbolTableEntryOriginal> findSymbolTableEntriesForVersionedTypeImport(TranspilerState state, VersionedNamedImportSpecifier_IM importspec) {
        boolean _not;
        boolean _isVersionedTypeImport = importspec.isVersionedTypeImport();
        boolean bl = _not = !_isVersionedTypeImport;
        if (_not) {
            SymbolTableEntryOriginal _findSymbolTableEntryForNamedImport = SymbolTableManagement.findSymbolTableEntryForNamedImport(state, importspec);
            return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new SymbolTableEntryOriginal[]{_findSymbolTableEntryForNamedImport}));
        }
        Predicate<SymbolTableEntryOriginal> _function = it -> {
            ImportSpecifier _importSpecifier = it.getImportSpecifier();
            return Objects.equal((Object)_importSpecifier, (Object)importspec);
        };
        return ((Stream)state.steCache.mapOriginal.values().parallelStream().unordered()).filter(_function).distinct().limit(importspec.getImportedTypeVersions().size()).collect(Collectors.toList());
    }

    public static void rename(TranspilerState state, SymbolTableEntry entry, String name) {
        if (entry instanceof SymbolTableEntryInternal) {
            throw new UnsupportedOperationException("cannot rename internal STEs " + entry);
        }
        if (entry instanceof SymbolTableEntryIMOnly) {
            ((SymbolTableEntryIMOnly)entry).setName(name);
        } else if (entry instanceof SymbolTableEntryOriginal) {
            boolean _tripleNotEquals;
            ((SymbolTableEntryOriginal)entry).setName(name);
            ImportSpecifier _importSpecifier = ((SymbolTableEntryOriginal)entry).getImportSpecifier();
            boolean bl = _tripleNotEquals = _importSpecifier != null;
            if (_tripleNotEquals) {
                throw new UnsupportedOperationException("renaming of symbol table entries not tested yet for imported elements!");
            }
        } else {
            throw new UnsupportedOperationException("Rename request for SymboltableEntries of unkown type : " + entry);
        }
    }
}

