/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.containers;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.util.Collection;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.ui.containers.N4JSExternalLibraryStorage2UriMapperContribution;
import org.eclipse.xtext.ui.resource.IStorage2UriMapperContribution;
import org.eclipse.xtext.util.Pair;

@Singleton
public class CompositeStorage2UriMapperContribution
implements IStorage2UriMapperContribution {
    private static final Iterable<Class<? extends IStorage2UriMapperContribution>> CONTRIBUTING_CLASSES = ImmutableSet.builder().add(N4JSExternalLibraryStorage2UriMapperContribution.class).build();
    @Inject
    private Injector injector;
    private final Collection<IStorage2UriMapperContribution> contributions = Lists.newArrayList();

    public void initializeCache() {
        for (Class<? extends IStorage2UriMapperContribution> clazz : CONTRIBUTING_CLASSES) {
            IStorage2UriMapperContribution contribution = (IStorage2UriMapperContribution)this.injector.getInstance(clazz);
            if (contribution == null) continue;
            this.contributions.add(contribution);
        }
        for (IStorage2UriMapperContribution contribution : this.contributions) {
            contribution.initializeCache();
        }
    }

    public boolean isRejected(IFolder folder) {
        return Iterables.all(this.contributions, c -> c.isRejected(folder));
    }

    public Iterable<Pair<IStorage, IProject>> getStorages(URI uri) {
        return FluentIterable.from(this.contributions).transformAndConcat(c -> c.getStorages(uri));
    }

    public URI getUri(IStorage storage) {
        for (IStorage2UriMapperContribution contribution : this.contributions) {
            URI uri = contribution.getUri(storage);
            if (uri == null) continue;
            return uri;
        }
        return null;
    }
}

