/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.accessModifiers;

import java.util.HashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.scoping.accessModifiers.AbstractTypeVisibilityChecker;
import org.eclipse.n4js.scoping.accessModifiers.InvisibleTypeOrVariableDescription;
import org.eclipse.n4js.scoping.accessModifiers.TypeVisibilityChecker;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.xtext.scoping.FilterWithErrorMarkerScope;
import org.eclipse.n4js.xtext.scoping.IEObjectDescriptionWithError;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public class VisibilityAwareTypeScope
extends FilterWithErrorMarkerScope {
    private final TypeVisibilityChecker checker;
    protected final HashMap<String, String> accessModifierSuggestionStore = new HashMap();
    protected final Resource contextResource;

    public VisibilityAwareTypeScope(IScope parent, TypeVisibilityChecker checker, Resource contextResource) {
        super(parent);
        this.checker = checker;
        this.contextResource = contextResource;
    }

    protected boolean isAccepted(IEObjectDescription description) {
        EObject proxyOrInstance = description.getEObjectOrProxy();
        if (proxyOrInstance instanceof Type) {
            Type type = (Type)proxyOrInstance;
            if (type.eIsProxy() && this.contextResource != null) {
                ResourceSet resourceSet = this.contextResource.getResourceSet();
                EObject fromResourceSet = resourceSet.getEObject(description.getEObjectURI(), false);
                if (fromResourceSet instanceof Type) {
                    type = (Type)fromResourceSet;
                } else {
                    return true;
                }
            }
            if (!type.eIsProxy()) {
                AbstractTypeVisibilityChecker.TypeVisibility typeVisibility = this.checker.isVisible(this.contextResource, type);
                if (typeVisibility.visibility) {
                    this.accessModifierSuggestionStore.put(description.getEObjectURI().toString(), typeVisibility.accessModifierSuggestion);
                }
                return typeVisibility.visibility;
            }
            throw new IllegalStateException("Unexpected proxy:" + type);
        }
        return true;
    }

    protected boolean tryAcceptWithoutResolve(IEObjectDescription originalDescr) {
        AbstractTypeVisibilityChecker.TypeVisibility typeVisibility = this.checker.isVisible(this.contextResource, originalDescr);
        if (typeVisibility.visibility) {
            this.accessModifierSuggestionStore.put(originalDescr.getEObjectURI().toString(), typeVisibility.accessModifierSuggestion);
        }
        return typeVisibility.visibility;
    }

    protected IEObjectDescriptionWithError wrapFilteredDescription(IEObjectDescription result) {
        return new InvisibleTypeOrVariableDescription(result, this.accessModifierSuggestionStore.get(result.getEObjectURI().toString()));
    }
}

