/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.utils;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.scoping.utils.CanLoadFromDescriptionHelper;
import org.eclipse.n4js.ts.scoping.PolyfillAwareSelectableBasedScope;
import org.eclipse.n4js.xtext.scoping.ForwardingEObjectDescription;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.scoping.IScope;

public class UserDataAwareScope
extends PolyfillAwareSelectableBasedScope {
    private final ResourceSet resourceSet;
    private final CanLoadFromDescriptionHelper canLoadFromDescriptionHelper;
    private final IContainer container;
    private final EClass type;

    public static IScope createScope(IScope outer, ISelectable selectable, Predicate<IEObjectDescription> filter, EClass type, boolean ignoreCase, ResourceSet resourceSet, CanLoadFromDescriptionHelper canLoadFromDescriptionHelper, IContainer container) {
        if (selectable == null || selectable.isEmpty()) {
            return outer;
        }
        UserDataAwareScope scope = new UserDataAwareScope(outer, selectable, filter, type, ignoreCase, resourceSet, canLoadFromDescriptionHelper, container);
        return scope;
    }

    UserDataAwareScope(IScope outer, ISelectable selectable, Predicate<IEObjectDescription> filter, EClass type, boolean ignoreCase, ResourceSet resourceSet, CanLoadFromDescriptionHelper canLoadFromDescriptionHelper, IContainer container) {
        super(outer, selectable, filter, type, ignoreCase);
        this.resourceSet = resourceSet;
        this.canLoadFromDescriptionHelper = canLoadFromDescriptionHelper;
        this.container = container;
        this.type = type;
    }

    public IEObjectDescription getSingleElement(QualifiedName name) {
        IEObjectDescription result = super.getSingleElement(name);
        return this.resolve(result);
    }

    private IEObjectDescription lazyResolve(IEObjectDescription original) {
        if (original instanceof LazyResolvedDescription) {
            return original;
        }
        if (original instanceof ResolvedDescription) {
            return original;
        }
        return new LazyResolvedDescription(original);
    }

    private IEObjectDescription resolve(IEObjectDescription original) {
        if (original instanceof ResolvedDescription) {
            return original;
        }
        if (original != null && original.getEObjectOrProxy().eIsProxy() && EcoreUtil2.isAssignableFrom((EClass)this.type, (EClass)original.getEClass())) {
            URI objectURI = original.getEObjectURI();
            URI resourceURI = objectURI.trimFragment();
            Resource resource = this.resourceSet.getResource(resourceURI, false);
            if (resource != null && resource.isLoaded()) {
                return original;
            }
            boolean mustLoadFromSource = this.canLoadFromDescriptionHelper.mustLoadFromSource(resourceURI, this.resourceSet);
            resource = this.resourceSet.getResource(resourceURI, mustLoadFromSource);
            if (resource != null && resource.isLoaded()) {
                return original;
            }
            if (mustLoadFromSource) {
                return original;
            }
            if (resource == null) {
                resource = this.canLoadFromDescriptionHelper.createResource(this.resourceSet, resourceURI);
            }
            if (resource instanceof N4JSResource) {
                EObject resolved;
                block14: {
                    if (resource.getContents().isEmpty()) {
                        N4JSResource casted = (N4JSResource)resource;
                        IResourceDescription resourceDescription = this.container.getResourceDescription(resourceURI);
                        if (resourceDescription != null) {
                            if (casted.isLoaded()) {
                                return original;
                            }
                            try {
                                if (!casted.loadFromDescription(resourceDescription)) {
                                    return original;
                                }
                                break block14;
                            }
                            catch (Exception e) {
                                casted.unload();
                                return original;
                            }
                        }
                        return original;
                    }
                }
                if ((resolved = this.resolveObject(objectURI, resource)) == null) {
                    return original;
                }
                return new ResolvedDescription(resolved, original);
            }
        }
        return original;
    }

    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        Iterable parent = super.getElements(name);
        return Iterables.transform((Iterable)parent, (Function)new Function<IEObjectDescription, IEObjectDescription>(){

            public IEObjectDescription apply(IEObjectDescription input) {
                return UserDataAwareScope.this.lazyResolve(input);
            }
        });
    }

    public Iterable<IEObjectDescription> getAllElements() {
        Iterable parent = super.getAllElements();
        return Iterables.transform((Iterable)parent, (Function)new Function<IEObjectDescription, IEObjectDescription>(){

            public IEObjectDescription apply(IEObjectDescription input) {
                return UserDataAwareScope.this.lazyResolve(input);
            }
        });
    }

    private EObject resolveObject(URI objectURI, Resource resource) {
        if (resource.isLoaded()) {
            throw new IllegalStateException("Should not be loaded beforehand");
        }
        EObject result = resource.getEObject(objectURI.fragment());
        if (resource.isLoaded()) {
            throw new IllegalStateException("Should not be loaded due to fragment traversal");
        }
        return result;
    }

    public class LazyResolvedDescription
    extends ForwardingEObjectDescription {
        private EObject resolved;

        LazyResolvedDescription(IEObjectDescription delegate) {
            super(delegate);
        }

        public EObject getEObjectOrProxy() {
            if (this.resolved == null) {
                this.resolved = UserDataAwareScope.this.resolve(this.delegate()).getEObjectOrProxy();
            }
            return this.resolved;
        }
    }

    public static class ResolvedDescription
    extends ForwardingEObjectDescription {
        private final EObject resolved;

        ResolvedDescription(EObject resolved, IEObjectDescription delegate) {
            super(delegate);
            if (resolved == null) {
                throw new NullPointerException("resolved instance may not be null");
            }
            this.resolved = resolved;
        }

        public EObject getEObjectOrProxy() {
            return this.resolved;
        }
    }
}

