/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.annotation;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import org.eclipse.n4js.annotation.TestWithScript;
import org.eclipse.xtend.lib.macro.AbstractMethodProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.CompilationStrategy;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class TestWithScriptProcessor
extends AbstractMethodProcessor {
    public void doTransform(MutableMethodDeclaration m, @Extension TransformationContext context) {
        boolean _not;
        Functions.Function1 _function = it -> {
            String _qualifiedName = it.getAnnotationTypeDeclaration().getQualifiedName();
            String _name = TestWithScript.class.getName();
            return Objects.equal((Object)_qualifiedName, (Object)_name);
        };
        Iterable annotations = IterableExtensions.filter((Iterable)m.getAnnotations(), (Functions.Function1)_function);
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)annotations);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            boolean _greaterThan;
            int _size = IterableExtensions.size((Iterable)annotations);
            boolean bl2 = _greaterThan = _size > 1;
            if (_greaterThan) {
                context.addError((Element)m, "Duplicate annotation of non-repeatable type @TestWithScript.\n\t\t\t\t\t\t\tOnly annotation types marked @Repeatable can be used multiple times at one target.");
                return;
            }
            AnnotationReference annotation = ((AnnotationReference[])Conversions.unwrapArray((Object)annotations, AnnotationReference.class))[0];
            String script = annotation.getStringValue("script");
            String selectedText = Strings.nullToEmpty((String)annotation.getStringValue("selectedText"));
            int occurrenceIndex = annotation.getIntValue("occurrenceIndex");
            if (script == null) {
                context.addError((Element)m, "Script cannot be null.");
                return;
            }
            if (occurrenceIndex < 0) {
                context.addError((Element)m, "Occurrence index must be a non-negative integer.");
            }
            int fromIndex = 0;
            int indexOf = 0;
            int numOfSuccess = -1;
            boolean stop = false;
            while (!stop) {
                indexOf = script.indexOf(selectedText, fromIndex);
                stop = indexOf > -1 ? (fromIndex = indexOf + 1) >= script.length() - 1 || occurrenceIndex == ++numOfSuccess : true;
            }
            if (numOfSuccess < 0) {
                context.addError((Element)m, "Cannot find selected text in script.");
                return;
            }
            if (occurrenceIndex != numOfSuccess) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Selected text exists only ");
                _builder.append((Object)(numOfSuccess + 1));
                _builder.append(" time");
                if (numOfSuccess != 0) {
                    _builder.append("s");
                }
                _builder.append(" in the script instead of ");
                _builder.append((Object)(occurrenceIndex + 1));
                _builder.append(".");
                context.addError((Element)m, _builder.toString());
                return;
            }
            int offset = indexOf;
            int length = selectedText.length();
            String originalName = m.getSimpleName();
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("__");
            _builder_1.append(originalName);
            String newName = _builder_1.toString();
            m.setSimpleName(newName);
            m.setVisibility(Visibility.PRIVATE);
            Procedures.Procedure1 _function_1 = it -> {
                it.setReturnType(m.getReturnType());
                it.setExceptions((TypeReference[])Conversions.unwrapArray((Object)m.getExceptions(), TypeReference.class));
                it.setDocComment(m.getDocComment());
                Iterable _parameters = it.getParameters();
                for (MutableParameterDeclaration p : _parameters) {
                    it.addParameter(p.getSimpleName(), p.getType());
                }
                Functions.Function1 _function_2 = it_1 -> {
                    String _name;
                    String _qualifiedName = it_1.getAnnotationTypeDeclaration().getQualifiedName();
                    return !Objects.equal((Object)_qualifiedName, (Object)(_name = TestWithScript.class.getName()));
                };
                Iterable _filter = IterableExtensions.filter((Iterable)m.getAnnotations(), (Functions.Function1)_function_2);
                for (AnnotationReference a : _filter) {
                    it.addAnnotation(a);
                }
                CompilationStrategy _function_3 = it_1 -> {
                    boolean _not_1;
                    StringConcatenation _builder_2 = new StringConcatenation();
                    String _name = ITextRegion.class.getName();
                    _builder_2.append(_name);
                    _builder_2.append(" selection = new ");
                    String _name_1 = TextRegion.class.getName();
                    _builder_2.append(_name_1);
                    _builder_2.append("(");
                    _builder_2.append((Object)offset);
                    _builder_2.append(", ");
                    _builder_2.append((Object)length);
                    _builder_2.append(");");
                    _builder_2.newLineIfNotEmpty();
                    String _name_2 = String.class.getName();
                    _builder_2.append(_name_2);
                    _builder_2.append(" script = \"");
                    _builder_2.append(script);
                    _builder_2.append("\";");
                    _builder_2.newLineIfNotEmpty();
                    boolean _isVoid = m.getReturnType().isVoid();
                    boolean bl = _not_1 = !_isVoid;
                    if (_not_1) {
                        _builder_2.append("return ");
                    }
                    _builder_2.append(newName);
                    _builder_2.append("(");
                    Iterable _parameters_1 = m.getParameters();
                    boolean _hasElements = false;
                    for (MutableParameterDeclaration p_1 : _parameters_1) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder_2.appendImmediate((Object)", ", "");
                        }
                        String _simpleName = p_1.getSimpleName();
                        _builder_2.append(_simpleName);
                    }
                    _builder_2.append(");");
                    _builder_2.newLineIfNotEmpty();
                    return _builder_2;
                };
                it.setBody(_function_3);
            };
            m.getDeclaringType().addMethod(originalName, _function_1);
            m.addParameter("selection", context.newTypeReference(ITextRegion.class, new TypeReference[0]));
            m.addParameter("script", context.newTypeReference(String.class, new TypeReference[0]));
            Iterable _annotations = m.getAnnotations();
            for (AnnotationReference a : _annotations) {
                m.removeAnnotation(a);
            }
        }
    }
}

