/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.types.util;

import org.eclipse.n4js.ts.types.MemberType;
import org.eclipse.n4js.ts.types.TMember;

public class NonSymetricMemberKey {
    public final String name;
    public final boolean isStatic;
    public final MemberType memberType;

    public static NonSymetricMemberKey of(TMember member) {
        return new NonSymetricMemberKey(member);
    }

    public NonSymetricMemberKey(TMember member) {
        this(member.getName(), member.isStatic(), member.getMemberType());
    }

    public NonSymetricMemberKey(String name, boolean isStatic, MemberType memberType) {
        this.name = name;
        this.isStatic = isStatic;
        this.memberType = memberType;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NonSymetricMemberKey) {
            NonSymetricMemberKey key = (NonSymetricMemberKey)obj;
            if (key.isStatic == this.isStatic && key.name.equals(this.name)) {
                return !this.accessorPair(this.memberType, key.memberType);
            }
        }
        return false;
    }

    private boolean accessorPair(MemberType mt1, MemberType mt2) {
        return mt1 == MemberType.GETTER && mt2 == MemberType.SETTER || mt1 == MemberType.SETTER && mt2 == MemberType.GETTER;
    }

    public int hashCode() {
        return (this.isStatic ? 31 : 0) + this.name.hashCode();
    }

    public String toString() {
        if (this.isStatic) {
            return "static " + this.name + " " + (Object)((Object)this.memberType);
        }
        return this.name;
    }
}

