/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server.build;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.n4js.ide.xtext.server.XWorkspaceManager;
import org.eclipse.n4js.ide.xtext.server.build.XBuildContext;
import org.eclipse.n4js.ide.xtext.server.build.XBuildRequest;
import org.eclipse.n4js.ide.xtext.server.build.XBuildResult;
import org.eclipse.n4js.ide.xtext.server.build.XIndexer;
import org.eclipse.n4js.ide.xtext.server.build.XSource2GeneratedMapping;
import org.eclipse.n4js.ide.xtext.server.build.XURIBasedFileSystemAccessFactory;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.generator.GeneratorContext;
import org.eclipse.xtext.generator.GeneratorDelegate;
import org.eclipse.xtext.generator.IContextualOutputConfigurationProvider2;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IFileSystemAccessExtension3;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.generator.OutputConfigurationProvider;
import org.eclipse.xtext.generator.URIBasedFileSystemAccess;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.persistence.IResourceStorageFacade;
import org.eclipse.xtext.resource.persistence.SerializableResourceDescription;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class XStatefulIncrementalBuilder {
    private XBuildContext context;
    private XBuildRequest request;
    @Inject
    private XIndexer indexer;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    protected void unloadResource(URI uri) {
        XtextResourceSet resourceSet = this.request.getResourceSet();
        Resource resource = resourceSet.getResource(uri, false);
        if (resource != null) {
            resourceSet.getResources().remove((Object)resource);
            resource.unload();
        }
    }

    public XBuildResult launch() {
        ArrayList<IResourceDescription.Delta> resolvedDeltas = new ArrayList<IResourceDescription.Delta>();
        try {
            XSource2GeneratedMapping newSource2GeneratedMapping = this.request.getState().getFileMappings();
            HashSet<URI> unloaded = new HashSet<URI>();
            for (URI deleted : this.request.getDeletedFiles()) {
                if (!unloaded.add(deleted)) continue;
                this.unloadResource(deleted);
            }
            for (URI dirty : this.request.getDirtyFiles()) {
                if (!unloaded.add(dirty)) continue;
                this.unloadResource(dirty);
            }
            for (URI source : this.request.getDeletedFiles()) {
                this.request.setResultIssues(source, Collections.emptyList());
                this.removeGeneratedFiles(source, newSource2GeneratedMapping);
            }
            XIndexer.XIndexResult result = this.indexer.computeAndIndexAffected(this.request, this.context);
            this.operationCanceledManager.checkCanceled(this.request.getCancelIndicator());
            for (IResourceDescription.Delta delta2 : result.getResourceDeltas()) {
                URI uri = delta2.getUri();
                if (delta2.getOld() != null && unloaded.add(uri)) {
                    this.unloadResource(uri);
                }
                if (delta2.getNew() != null) continue;
                resolvedDeltas.add(delta2);
            }
            FluentIterable uris = FluentIterable.from(result.getResourceDeltas()).filter(delta -> delta.getNew() != null).transform(IResourceDescription.Delta::getUri);
            Iterable deltas = this.context.executeClustered((Iterable<URI>)uris, resource -> this.buildClustured((Resource)resource, newSource2GeneratedMapping, result));
            Iterables.addAll(resolvedDeltas, deltas);
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        return new XBuildResult(this.request.getState(), resolvedDeltas);
    }

    private void removeGeneratedFiles(URI source, XSource2GeneratedMapping source2GeneratedMapping) {
        Map<URI, String> outputConfigMap = source2GeneratedMapping.deleteSourceAndGetOutputConfigs(source);
        IResourceServiceProvider serviceProvider = this.context.getResourceServiceProvider(source);
        IContextualOutputConfigurationProvider2 outputConfigurationProvider = (IContextualOutputConfigurationProvider2)serviceProvider.get(IContextualOutputConfigurationProvider2.class);
        XtextResourceSet resourceSet = this.request.getResourceSet();
        Set outputConfigs = outputConfigurationProvider.getOutputConfigurations((ResourceSet)resourceSet);
        ImmutableMap outputConfigsMap = Maps.uniqueIndex((Iterable)outputConfigs, OutputConfiguration::getName);
        URIConverter uriConverter = resourceSet.getURIConverter();
        for (URI generated : outputConfigMap.keySet()) {
            OutputConfiguration config = (OutputConfiguration)outputConfigsMap.get(outputConfigMap.get(generated));
            if (config == null || !config.isCleanUpDerivedResources()) continue;
            try {
                uriConverter.delete(generated, CollectionLiterals.emptyMap());
                this.request.setResultDeleteFile(generated);
            }
            catch (IOException e) {
                Exceptions.sneakyThrow((Throwable)e);
            }
        }
    }

    private IResourceDescription.Delta buildClustured(Resource resource, XSource2GeneratedMapping newSource2GeneratedMapping, XIndexer.XIndexResult result) {
        CancelIndicator cancelIndicator = this.request.getCancelIndicator();
        this.operationCanceledManager.checkCanceled(cancelIndicator);
        resource.getContents();
        EcoreUtil2.resolveLazyCrossReferences((Resource)resource, (CancelIndicator)CancelIndicator.NullImpl);
        this.operationCanceledManager.checkCanceled(cancelIndicator);
        URI source = resource.getURI();
        IResourceServiceProvider serviceProvider = this.getResourceServiceProvider(resource);
        IResourceDescription.Manager manager = serviceProvider.getResourceDescriptionManager();
        IResourceValidator resourceValidator = serviceProvider.getResourceValidator();
        IResourceDescription description = manager.getResourceDescription(resource);
        SerializableResourceDescription copiedDescription = SerializableResourceDescription.createCopy((IResourceDescription)description);
        result.getNewIndex().addDescription(source, (IResourceDescription)copiedDescription);
        this.operationCanceledManager.checkCanceled(cancelIndicator);
        if (!this.request.isIndexOnly()) {
            List issues = resourceValidator.validate(resource, CheckMode.ALL, this.request.getCancelIndicator());
            this.request.setResultIssues(source, issues);
            boolean proceedGenerate = this.request.shouldGenerate(source);
            if (proceedGenerate) {
                this.operationCanceledManager.checkCanceled(cancelIndicator);
                this.generate(resource, newSource2GeneratedMapping, serviceProvider);
            } else {
                this.removeGeneratedFiles(resource.getURI(), newSource2GeneratedMapping);
            }
        }
        IResourceDescription old = this.context.getOldState().getResourceDescriptions().getResourceDescription(source);
        return manager.createDelta(old, (IResourceDescription)copiedDescription);
    }

    private IResourceServiceProvider getResourceServiceProvider(Resource resource) {
        if (resource instanceof XtextResource) {
            return ((XtextResource)resource).getResourceServiceProvider();
        }
        return this.context.getResourceServiceProvider(resource.getURI());
    }

    protected void generate(Resource resource, XSource2GeneratedMapping newMappings, IResourceServiceProvider serviceProvider) {
        IResourceStorageFacade resourceStorageFacade;
        GeneratorDelegate generator = (GeneratorDelegate)serviceProvider.get(GeneratorDelegate.class);
        if (generator == null) {
            return;
        }
        if (this.isResourceInOutputDirectory(resource, serviceProvider)) {
            return;
        }
        URI source = resource.getURI();
        Set<URI> previous = newMappings.deleteSource(source);
        URIBasedFileSystemAccess fileSystemAccess = this.createFileSystemAccess(serviceProvider, resource);
        fileSystemAccess.setBeforeWrite((uri, outputCfgName, contents) -> {
            newMappings.addSource2Generated(source, uri, outputCfgName);
            previous.remove(uri);
            this.request.setResultGeneratedFile(source, uri);
            return contents;
        });
        fileSystemAccess.setBeforeDelete(uri -> {
            newMappings.deleteGenerated(uri);
            this.request.setResultDeleteFile(uri);
            return true;
        });
        fileSystemAccess.setContext((Object)resource);
        if (this.request.isWriteStorageResources() && resource instanceof StorageAwareResource && (resourceStorageFacade = ((StorageAwareResource)resource).getResourceStorageFacade()) != null) {
            resourceStorageFacade.saveResource((StorageAwareResource)resource, (IFileSystemAccessExtension3)fileSystemAccess);
        }
        GeneratorContext generatorContext = new GeneratorContext();
        generatorContext.setCancelIndicator(this.request.getCancelIndicator());
        generator.generate(resource, (IFileSystemAccess2)fileSystemAccess, (IGeneratorContext)generatorContext);
        XtextResourceSet resourceSet = this.request.getResourceSet();
        for (URI noLongerCreated : previous) {
            try {
                resourceSet.getURIConverter().delete(noLongerCreated, CollectionLiterals.emptyMap());
                this.request.setResultDeleteFile(noLongerCreated);
            }
            catch (IOException e) {
                Exceptions.sneakyThrow((Throwable)e);
            }
        }
    }

    private boolean isResourceInOutputDirectory(Resource resource, IResourceServiceProvider serviceProvider) {
        XWorkspaceManager workspaceManager = (XWorkspaceManager)serviceProvider.get(XWorkspaceManager.class);
        if (workspaceManager == null) {
            return false;
        }
        OutputConfigurationProvider outputConfProvider = (OutputConfigurationProvider)serviceProvider.get(OutputConfigurationProvider.class);
        URI resourceUri = resource.getURI();
        IProjectConfig projectConfig = workspaceManager.getProjectConfig(resourceUri);
        Set outputConfigurations = outputConfProvider.getOutputConfigurations(resource);
        URI projectBaseUri = projectConfig.getPath();
        Path resourcePath = Paths.get(resourceUri.toFileString(), new String[0]);
        for (OutputConfiguration outputConf : outputConfigurations) {
            for (String outputDir : outputConf.getOutputDirectories()) {
                URI outputUri = projectBaseUri.appendSegment(outputDir);
                Path outputPath = Paths.get(outputUri.toFileString(), new String[0]);
                if (!resourcePath.startsWith(outputPath)) continue;
                return true;
            }
        }
        return false;
    }

    protected URIBasedFileSystemAccess createFileSystemAccess(IResourceServiceProvider serviceProvider, Resource resource) {
        XURIBasedFileSystemAccessFactory fsaFactory = (XURIBasedFileSystemAccessFactory)serviceProvider.get(XURIBasedFileSystemAccessFactory.class);
        return fsaFactory.newFileSystemAccess(resource, this.request);
    }

    protected XBuildContext getContext() {
        return this.context;
    }

    protected void setContext(XBuildContext context) {
        this.context = context;
    }

    protected XBuildRequest getRequest() {
        return this.request;
    }

    protected void setRequest(XBuildRequest request) {
        this.request = request;
    }
}

