/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.TreeMap;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.config.hosts.HostConfigEntryResolver;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.transport.ssh.OpenSshConfigFile;
import org.eclipse.jgit.internal.transport.sshd.JGitHostConfigEntry;

public class JGitSshConfig
implements HostConfigEntryResolver {
    private final OpenSshConfigFile configFile;
    private final String localUserName;

    public JGitSshConfig(@NonNull File home, File config, @NonNull String localUserName) {
        this.localUserName = localUserName;
        this.configFile = config == null ? null : new OpenSshConfigFile(home, config, localUserName);
    }

    public HostConfigEntry resolveEffectiveHost(String host, int port, SocketAddress localAddress, String username, AttributeRepository attributes) throws IOException {
        String user;
        OpenSshConfigFile.HostEntry entry = this.configFile == null ? new OpenSshConfigFile.HostEntry() : this.configFile.lookup(host, port, username);
        JGitHostConfigEntry config = new JGitHostConfigEntry();
        TreeMap allOptions = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        allOptions.putAll(entry.getOptions());
        entry.getMultiValuedOptions().entrySet().stream().forEach(e -> {
            String string = allOptions.put((String)e.getKey(), String.join((CharSequence)",", (Iterable)e.getValue()));
        });
        config.setProperties(allOptions);
        config.setMultiValuedOptions(entry.getMultiValuedOptions());
        String hostName = entry.getValue("HostName");
        if (hostName == null || hostName.isEmpty()) {
            hostName = host;
        }
        config.setHostName(hostName);
        config.setProperty("HostName", hostName);
        config.setHost(SshdSocketAddress.isIPv6Address((String)hostName) ? "" : hostName);
        String string = user = username != null && !username.isEmpty() ? username : entry.getValue("User");
        if (user == null || user.isEmpty()) {
            user = this.localUserName;
        }
        config.setUsername(user);
        config.setProperty("User", user);
        int p = port >= 0 ? port : OpenSshConfigFile.positive((String)entry.getValue("Port"));
        config.setPort(p >= 0 ? p : 22);
        config.setProperty("Port", Integer.toString(config.getPort()));
        config.setIdentities(entry.getValues("IdentityFile"));
        config.setIdentitiesOnly(OpenSshConfigFile.flag((String)entry.getValue("IdentitiesOnly")));
        return config;
    }
}

