/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.projectModel.locations;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.utils.io.FileDeleter;

public final class FileURI
extends SafeURI<FileURI> {
    private File cachedFile;

    public FileURI(URI location) {
        super(location);
    }

    public FileURI(File file) {
        super(FileURI.toFileURI(file));
        this.cachedFile = file;
    }

    private static URI toFileURI(File file) {
        URI fileURI = URI.createFileURI((String)file.getAbsolutePath());
        if (fileURI.authority() == null) {
            fileURI = URI.createHierarchicalURI((String)fileURI.scheme(), (String)"", (String)fileURI.device(), (String[])fileURI.segments(), (String)fileURI.query(), (String)fileURI.fragment());
        }
        return fileURI;
    }

    @Override
    protected URI validate(URI given) throws IllegalArgumentException, NullPointerException {
        super.validate(given);
        Preconditions.checkNotNull((Object)given.authority(), (String)"%s", (Object)given);
        Preconditions.checkArgument((boolean)given.isFile(), (String)"%s", (Object)given);
        Preconditions.checkArgument((boolean)"file".equalsIgnoreCase(given.scheme()), (String)"%s", (Object)given);
        return given;
    }

    public FileURI trimFragment() {
        return new FileURI(this.toURI().trimFragment());
    }

    public String toFileString() {
        return this.toURI().toFileString();
    }

    @Override
    public boolean exists() {
        return new File(this.toURI().toFileString()).exists();
    }

    @Override
    public boolean isFile() {
        return this.getCachedFile().isFile();
    }

    private File getCachedFile() {
        if (this.cachedFile != null) {
            return this.cachedFile;
        }
        this.cachedFile = new File(this.toURI().toFileString());
        return this.cachedFile;
    }

    @Override
    public String getName() {
        return this.toURI().lastSegment();
    }

    @Override
    public boolean isDirectory() {
        return this.getCachedFile().isDirectory();
    }

    @Override
    public Iterable<? extends FileURI> getChildren() {
        Object[] children = this.getCachedFile().listFiles();
        if (children == null) {
            return Collections.emptyList();
        }
        return FluentIterable.from((Object[])children).transform(FileURI::new);
    }

    @Override
    public InputStream getContents() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.getCachedFile()));
    }

    @Override
    public String getAbsolutePath() {
        return this.toURI().path();
    }

    @Override
    protected FileURI createFrom(URI uri) {
        return new FileURI(uri);
    }

    @Override
    public FileURI resolveSymLinks() {
        try {
            return new FileURI(this.getCachedFile().getCanonicalFile());
        }
        catch (IOException e) {
            return this;
        }
    }

    @Override
    public Iterator<FileURI> getAllChildren() {
        File container = this.getCachedFile();
        if (container.isDirectory()) {
            AbstractTreeIterator<File> treeIterator = new AbstractTreeIterator<File>((Object)container, false){

                protected Iterator<? extends File> getChildren(Object root) {
                    File file;
                    if (root instanceof File && (file = (File)root).isDirectory()) {
                        if (file.getName().equals("node_modules")) {
                            return Collections.emptyIterator();
                        }
                        return Arrays.asList(((File)root).listFiles()).iterator();
                    }
                    return Collections.emptyIterator();
                }
            };
            return FluentIterable.from(() -> FileURI.lambda$1((AbstractTreeIterator)treeIterator)).filter(File::isFile).transform(FileURI::new).iterator();
        }
        return Collections.emptyIterator();
    }

    @Override
    public void delete(Consumer<? super IOException> errorHandler) {
        FileDeleter.delete((File)this.getCachedFile(), errorHandler);
    }

    @Override
    public FileURI toFileURI() {
        return this;
    }

    @Override
    public File toJavaIoFile() {
        return this.getCachedFile();
    }

    private static /* synthetic */ Iterator lambda$1(AbstractTreeIterator abstractTreeIterator) {
        return abstractTreeIterator;
    }
}

