/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.filechecker;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class Report
implements Comparable<Report> {
    public final Path path;
    public final List<String> problems = new ArrayList<String>();
    private Throwable error;
    private boolean hasCopyrightHeader = false;
    private boolean isIgnored = false;
    private boolean isThirdParty = false;

    public Report(Path path) {
        this.path = path;
    }

    public void setToIgnored() {
        this.isIgnored = true;
    }

    public void setToThirdParty() {
        this.isThirdParty = true;
    }

    public void setToHasCRH() {
        this.hasCopyrightHeader = true;
    }

    public void setThrowable(Throwable error) {
        this.error = error;
    }

    public boolean isInTestProject() {
        String testProjectSuffix = "tests" + File.separator;
        boolean isInTestProject = this.path.toString().contains(testProjectSuffix);
        boolean isJavaTestFile = this.path.toString().endsWith("Test.java");
        boolean isInHlcTestDir = this.path.toString().contains("org.eclipse.n4js.hlc/src/test");
        return isInTestProject || isJavaTestFile || isInHlcTestDir;
    }

    public boolean isNotInTestProject() {
        return !this.isInTestProject();
    }

    public boolean isInN4JSRepo() {
        boolean containsRepoDir = this.path.toString().contains(String.valueOf(File.separator) + "n4js" + File.separator);
        return containsRepoDir;
    }

    public boolean isInN4JSExtendedRepo() {
        boolean containsRepoDir = this.path.toString().contains(String.valueOf(File.separator) + "n4js-extended" + File.separator);
        return containsRepoDir;
    }

    public boolean isIgnored() {
        return this.isIgnored;
    }

    public boolean isNotIgnored() {
        return !this.isIgnored();
    }

    public boolean isThirdParty() {
        return this.isThirdParty;
    }

    public boolean isErroneous() {
        return this.error != null;
    }

    public boolean isMissingCopyrightHeader() {
        return this.path.toFile().isFile() && !this.isHavingCopyrightHeader();
    }

    public boolean isHavingCopyrightHeader() {
        return this.path.toFile().isFile() && (this.hasCopyrightHeader || this.isThirdParty());
    }

    public boolean isValid() {
        return !this.isIgnored() && this.problems.isEmpty();
    }

    public boolean isInvalid() {
        return !this.isIgnored() && !this.problems.isEmpty();
    }

    public String getFileExtension() {
        String pathStr = this.path.toString();
        int idxDot = pathStr.lastIndexOf(".") + 1;
        int idxFileSep = pathStr.lastIndexOf(File.separator) + 1;
        String extension = pathStr.substring(Math.max(idxDot, idxFileSep));
        return extension;
    }

    public Throwable getError() {
        return this.error;
    }

    @Override
    public int compareTo(Report report) {
        return this.path.compareTo(report.path);
    }
}

