/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.editor.syntaxcoloring;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import org.antlr.runtime.CommonToken;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.n4js.services.N4JSGrammarAccess;
import org.eclipse.n4js.ts.typeRefs.TypeRefsPackage;
import org.eclipse.n4js.ui.editor.syntaxcoloring.PseudoTokens;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;

@Singleton
public class TokenTypeRewriter
implements PseudoTokens {
    private final Map<AbstractElement, Integer> mapping;

    @Inject
    public TokenTypeRewriter(N4JSGrammarAccess ga) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        TokenTypeRewriter.rewriteRegExLiterals(ga, (ImmutableMap.Builder<AbstractElement, Integer>)builder);
        TokenTypeRewriter.rewriteTemplateLiterals(ga, (ImmutableMap.Builder<AbstractElement, Integer>)builder);
        TokenTypeRewriter.rewriteAnnotationReferences(ga, (ImmutableMap.Builder<AbstractElement, Integer>)builder);
        TokenTypeRewriter.rewriteTypeReferences(ga, (ImmutableMap.Builder<AbstractElement, Integer>)builder);
        TokenTypeRewriter.rewriteIdentifiers(ga, (ImmutableMap.Builder<AbstractElement, Integer>)builder);
        TokenTypeRewriter.rewriteTypeVariables(ga, (ImmutableMap.Builder<AbstractElement, Integer>)builder);
        TokenTypeRewriter.rewriteNumberLiterals(ga, (ImmutableMap.Builder<AbstractElement, Integer>)builder);
        TokenTypeRewriter.rewriteKeywords(ga, (ImmutableMap.Builder<AbstractElement, Integer>)builder);
        this.mapping = builder.build();
    }

    private static void rewriteKeywords(N4JSGrammarAccess ga, ImmutableMap.Builder<AbstractElement, Integer> builder) {
        N4JSKeywords keywords = new N4JSKeywords();
        for (ParserRule rule : GrammarUtil.allParserRules((Grammar)ga.getGrammar())) {
            if (GrammarUtil.isDatatypeRule((ParserRule)rule)) continue;
            TokenTypeRewriter.rewriteKeywords((AbstractRule)rule, keywords, builder);
        }
        for (ParserRule rule : GrammarUtil.allEnumRules((Grammar)ga.getGrammar())) {
            TokenTypeRewriter.rewriteKeywords((AbstractRule)rule, keywords, builder);
        }
    }

    private static void rewriteKeywords(AbstractRule rule, N4JSKeywords keywords, ImmutableMap.Builder<AbstractElement, Integer> builder) {
        for (EObject obj : EcoreUtil2.eAllContents((EObject)rule.getAlternatives())) {
            Keyword keyword;
            Integer type;
            if (!(obj instanceof Keyword) || (type = keywords.getTokenType(keyword = (Keyword)obj)) == null) continue;
            if (keyword.eContainer() instanceof EnumLiteralDeclaration) {
                builder.put((Object)((AbstractElement)keyword.eContainer()), (Object)type);
                continue;
            }
            builder.put((Object)keyword, (Object)type);
        }
    }

    private static void rewriteTemplateLiterals(N4JSGrammarAccess ga, ImmutableMap.Builder<AbstractElement, Integer> builder) {
        builder.put((Object)ga.getTemplateExpressionEndAccess().getRightCurlyBracketKeyword(), (Object)144);
    }

    private static void rewriteTypeVariables(N4JSGrammarAccess ga, ImmutableMap.Builder<AbstractElement, Integer> builder) {
        builder.put((Object)ga.getTypeVariableAccess().getNameAssignment_1(), (Object)172);
    }

    private static void rewriteRegExLiterals(N4JSGrammarAccess ga, ImmutableMap.Builder<AbstractElement, Integer> builder) {
        builder.put((Object)ga.getREGEX_LITERALAccess().getSolidusKeyword_0_0(), (Object)136);
        builder.put((Object)ga.getREGEX_LITERALAccess().getSolidusEqualsSignKeyword_0_1(), (Object)136);
    }

    private static void rewriteAnnotationReferences(N4JSGrammarAccess ga, ImmutableMap.Builder<AbstractElement, Integer> builder) {
        builder.put((Object)ga.getAnnotationNoAtSignAccess().getNameAssignment_0(), (Object)80);
        builder.put((Object)ga.getFunctionTypeExpressionOLDAccess().getThisKeyword_2_1(), (Object)80);
        builder.put((Object)ga.getPromisifyExpressionAccess().getPromisifyKeyword_0_0_2(), (Object)80);
    }

    private static void rewriteTypeReferences(N4JSGrammarAccess ga, ImmutableMap.Builder<AbstractElement, Integer> builder) {
        for (ParserRule rule : GrammarUtil.allParserRules((Grammar)ga.getGrammar())) {
            for (EObject obj : EcoreUtil2.eAllContents((EObject)rule.getAlternatives())) {
                AbstractRule calledRule;
                EClassifier classifier;
                Assignment assignment;
                AbstractElement terminal;
                if (!(obj instanceof Assignment) || !((terminal = (assignment = (Assignment)obj).getTerminal()) instanceof RuleCall) || !((classifier = (calledRule = ((RuleCall)terminal).getRule()).getType().getClassifier()) instanceof EClass) || !TypeRefsPackage.Literals.TYPE_REF.isSuperTypeOf((EClass)classifier)) continue;
                builder.put((Object)assignment, (Object)169);
            }
        }
    }

    private static void rewriteIdentifiers(N4JSGrammarAccess ga, ImmutableMap.Builder<AbstractElement, Integer> builder) {
        ImmutableSet identifierRules = ImmutableSet.of((Object)ga.getBindingIdentifierRule(), (Object)ga.getIdentifierNameRule(), (Object)ga.getIDENTIFIERRule());
        for (ParserRule rule : GrammarUtil.allParserRules((Grammar)ga.getGrammar())) {
            for (EObject obj : EcoreUtil2.eAllContents((EObject)rule.getAlternatives())) {
                AbstractRule calledRule;
                if (!(obj instanceof Assignment)) continue;
                Assignment assignment = (Assignment)obj;
                AbstractElement terminal = assignment.getTerminal();
                int type = 126;
                if (terminal instanceof CrossReference) {
                    terminal = ((CrossReference)terminal).getTerminal();
                    type = 171;
                }
                if (!(terminal instanceof RuleCall) || !identifierRules.contains((Object)(calledRule = ((RuleCall)terminal).getRule()))) continue;
                builder.put((Object)assignment, (Object)type);
            }
        }
    }

    private static void rewriteNumberLiterals(N4JSGrammarAccess ga, ImmutableMap.Builder<AbstractElement, Integer> builder) {
        for (ParserRule rule : GrammarUtil.allParserRules((Grammar)ga.getGrammar())) {
            for (EObject obj : EcoreUtil2.eAllContents((EObject)rule.getAlternatives())) {
                AbstractRule calledRule;
                EClassifier classifier;
                Assignment assignment;
                AbstractElement terminal;
                if (!(obj instanceof Assignment) || !((terminal = (assignment = (Assignment)obj).getTerminal()) instanceof RuleCall) || (classifier = (calledRule = ((RuleCall)terminal).getRule()).getType().getClassifier()) != EcorePackage.Literals.EBIG_DECIMAL) continue;
                builder.put((Object)assignment, (Object)170);
            }
        }
    }

    public Integer rewrite(CommonToken token, AbstractElement element) {
        Integer mappedType = this.mapping.get(element);
        if (mappedType != null && token != null) {
            token.setType(mappedType.intValue());
        }
        return mappedType;
    }

    public static class N4JSKeywords {
        public static final ImmutableSet<String> es5Keywords = ImmutableSet.of((Object)"break", (Object)"case", (Object)"catch", (Object)"continue", (Object)"debugger", (Object)"default", (Object[])new String[]{"delete", "do", "else", "finally", "for", "function", "if", "in", "instanceof", "new", "return", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with"});
        public static final ImmutableSet<String> es6Keywords = ImmutableSet.of((Object)"class", (Object)"const", (Object)"export", (Object)"import", (Object)"yield");
        public static final ImmutableSet<String> futureKeywords = ImmutableSet.of((Object)"enum");
        public static final ImmutableSet<String> nullLiteral = ImmutableSet.of((Object)"null");
        public static final ImmutableSet<String> booleanLiteral = ImmutableSet.of((Object)"true", (Object)"false");
        public static final ImmutableSet<String> n4jsKeyword = ImmutableSet.of((Object)"abstract", (Object)"as", (Object)"from", (Object)"extends", (Object)"implements", (Object)"interface", (Object[])new String[]{"let", "of", "static", "super", "set", "get", "external", "project", "private", "protected", "public", "target", "async", "await", "out"});
        public static final ImmutableSet<String> keywordFromTypeRef = ImmutableSet.of((Object)"type", (Object)"union", (Object)"intersection", (Object)"constructor");
        public static final ImmutableSet<String> hardcodedAnnotationAndSemanticKeywords = ImmutableSet.of((Object)"This", (Object)"Promisify");

        public Integer getTokenType(Keyword kw) {
            String text = kw.getValue();
            Integer type = this.getTokenType(text, es5Keywords, 174, null);
            type = this.getTokenType(text, es6Keywords, 175, type);
            type = this.getTokenType(text, futureKeywords, 176, type);
            type = this.getTokenType(text, nullLiteral, 177, type);
            type = this.getTokenType(text, booleanLiteral, 178, type);
            type = this.getTokenType(text, n4jsKeyword, 179, type);
            return type;
        }

        private Integer getTokenType(String text, ImmutableSet<String> set, int type, Integer refinedType) {
            if (refinedType != null) {
                if (set.contains((Object)text)) {
                    throw new RuntimeException("duplicate keyword declaration: " + text);
                }
                return refinedType;
            }
            if (set.contains((Object)text)) {
                return type;
            }
            return null;
        }
    }
}

