/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.helper;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.n4js.cli.helper.AbstractCliCompileTest;
import org.eclipse.n4js.cli.helper.N4CliHelper;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.utils.io.FileDeleter;
import org.junit.Before;

public abstract class AbstractCliJarTest
extends AbstractCliCompileTest {
    public static final String N4JSC_JAR = "n4jsc.jar";
    public static final String TARGET = "target";
    public static final String TARGET_FOLDER = "target/";
    public static final String WORKSPACE_FOLDER = "wsp";
    protected final Path fixture;
    protected final Predicate<N4JSProjectName> n4jsLibsPredicate;

    protected AbstractCliJarTest(String fixture) {
        this(fixture, false);
    }

    protected AbstractCliJarTest(String fixturePath, boolean includeN4jsLibraries) {
        super(AbstractCliCompileTest.N4jscVariant.exprocess);
        this.fixture = Paths.get(fixturePath, new String[0]);
        this.n4jsLibsPredicate = includeN4jsLibraries ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    @Before
    public final void setupWorkspace() throws IOException {
        Path wsp = Paths.get(TARGET, WORKSPACE_FOLDER);
        Files.createDirectories(wsp, new FileAttribute[0]);
        N4CliHelper.setupWorkspace(this.fixture, wsp, this.n4jsLibsPredicate);
    }

    protected void deleteProject(String projectName) throws IOException {
        File wsp = new File(TARGET, WORKSPACE_FOLDER);
        File project = new File(wsp, projectName);
        FileDeleter.delete((Path)project.toPath());
    }
}

