/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.nature;

import com.google.inject.Inject;
import org.eclipse.core.resources.IResource;
import org.eclipse.xtext.builder.nature.Messages;
import org.eclipse.xtext.builder.nature.ToggleXtextNatureCommand;
import org.eclipse.xtext.ui.editor.IXtextEditorCallback;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.util.DontAskAgainDialogs;

public class NatureAddingEditorCallback
extends IXtextEditorCallback.NullImpl {
    private static final String ADD_XTEXT_NATURE = "add_xtext_nature";
    @Inject
    private ToggleXtextNatureCommand toggleNature;
    @Inject
    private DontAskAgainDialogs dialogs;

    public void afterCreatePartControl(XtextEditor editor) {
        IResource resource = editor.getResource();
        if (resource != null && !this.toggleNature.hasNature(resource.getProject()) && resource.getProject().isAccessible() && !resource.getProject().isHidden()) {
            String title = Messages.NatureAddingEditorCallback_MessageDialog_Title;
            String message = String.valueOf(Messages.NatureAddingEditorCallback_MessageDialog_Msg0) + resource.getProject().getName() + Messages.NatureAddingEditorCallback_MessageDialog_Msg1;
            boolean addNature = false;
            if ("prompt".equals(this.dialogs.getUserDecision(ADD_XTEXT_NATURE))) {
                int userAnswer = this.dialogs.askUser(message, title, ADD_XTEXT_NATURE, editor.getEditorSite().getShell());
                if (userAnswer == 2) {
                    addNature = true;
                } else if (userAnswer == 1) {
                    return;
                }
            } else if ("always".equals(this.dialogs.getUserDecision(ADD_XTEXT_NATURE))) {
                addNature = true;
            }
            if (addNature) {
                this.toggleNature.toggleNature(resource.getProject());
            }
        }
    }
}

