/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.impl.LiteralOrComputedPropertyNameImpl;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ui.utils.HandlerServiceUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.editor.XtextEditor;

public class TestDiscoveryUIUtils {
    public static final URI getLocationForSelectedObject(Object selectedObject) {
        if (selectedObject instanceof ISelection) {
            return TestDiscoveryUIUtils.getLocationForSelection((ISelection)selectedObject);
        }
        if (selectedObject instanceof IResource) {
            return TestDiscoveryUIUtils.getLocationForResource((IResource)selectedObject);
        }
        if (selectedObject instanceof IEditorPart) {
            return TestDiscoveryUIUtils.getLocationForEditor((IEditorPart)selectedObject);
        }
        if (selectedObject instanceof IFileEditorInput) {
            return TestDiscoveryUIUtils.getLocationForEditorInput((IFileEditorInput)selectedObject);
        }
        return null;
    }

    public static final URI getLocationForSelection(ISelection selection) {
        Object selObj;
        if (selection instanceof IStructuredSelection && (selObj = ((IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
            return TestDiscoveryUIUtils.getLocationForResource((IResource)selObj);
        }
        return null;
    }

    public static final URI getLocationForResource(IResource resource) {
        String pathName = resource.getFullPath().toString();
        return URI.createPlatformResourceURI((String)pathName, (boolean)true);
    }

    public static final URI getLocationForEditor(IEditorPart editor) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            return TestDiscoveryUIUtils.getLocationForEditorInput((IFileEditorInput)input);
        }
        return null;
    }

    public static final URI getLocationForEditorInput(IFileEditorInput fileEditorInput) {
        TModule module;
        N4MethodDeclaration method;
        ITextSelection textSelection;
        EObject selectedElement;
        if (fileEditorInput == null) {
            return null;
        }
        XtextEditor editor = (XtextEditor)HandlerServiceUtils.getActiveEditor(XtextEditor.class).orNull();
        if (editor != null && fileEditorInput.equals(editor.getEditorInput()) && Thread.currentThread() == Display.getDefault().getThread() && editor.getSelectionProvider().getSelection() instanceof ITextSelection && (selectedElement = TestDiscoveryUIUtils.getSelectedElement(editor, textSelection = (ITextSelection)editor.getSelectionProvider().getSelection())) instanceof LiteralOrComputedPropertyNameImpl && selectedElement.eContainer() instanceof N4MethodDeclaration && !(method = (N4MethodDeclaration)selectedElement.eContainer()).eIsProxy() && AnnotationDefinition.TEST_METHOD.hasAnnotation((AnnotableElement)method) && (module = N4JSResource.getModule((Resource)method.eResource())) != null) {
            URI uri = EcoreUtil.getURI((EObject)method);
            return uri;
        }
        return TestDiscoveryUIUtils.getFileURI(fileEditorInput);
    }

    private static EObject getSelectedElement(XtextEditor editor, ITextSelection textSelection) {
        return (EObject)editor.getDocument().modify(resource -> {
            IResourceServiceProvider serviceProvider = resource.getResourceServiceProvider();
            EObjectAtOffsetHelper offsetHelper = (EObjectAtOffsetHelper)serviceProvider.get(EObjectAtOffsetHelper.class);
            return offsetHelper.resolveElementAt(resource, textSelection.getOffset());
        });
    }

    private static URI getFileURI(IFileEditorInput fileEditorInput) {
        IFile originalFileToRun = fileEditorInput.getFile();
        String pathName = originalFileToRun.getFullPath().toString();
        return URI.createPlatformResourceURI((String)pathName, (boolean)true);
    }
}

