/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.expectation.impl;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.List;
import org.eclipse.xpect.XpectArgument;
import org.eclipse.xpect.expectation.IExpectationRegion;
import org.eclipse.xpect.expectation.IMultiLineExpectationRegion;
import org.eclipse.xpect.expectation.ISingleLineExpectationRegion;
import org.eclipse.xpect.expectation.impl.TargetSyntaxSupport;
import org.eclipse.xpect.text.IReplacement;
import org.eclipse.xpect.text.Replacement;
import org.eclipse.xpect.text.Text;

public class AbstractExpectation {
    private final XpectArgument argument;
    private final IExpectationRegion region;
    private final TargetSyntaxSupport.TargetLiteralSupport targetLiteral;
    private final TargetSyntaxSupport targetSyntax;

    public AbstractExpectation(XpectArgument argument, TargetSyntaxSupport targetSyntax) {
        this.argument = argument;
        this.region = argument.getStatement().getRelatedRegion(IExpectationRegion.class);
        Preconditions.checkPositionIndex((int)this.region.getOffset(), (int)this.region.getDocument().length());
        Preconditions.checkPositionIndex((int)(this.region.getOffset() + this.region.getLength()), (int)this.region.getDocument().length());
        this.targetSyntax = targetSyntax;
        this.targetLiteral = targetSyntax.getLiteralSupport(this.region.getOffset());
    }

    protected String findValidSeparator(String value, String suggestedSeparator) {
        if (suggestedSeparator != null && !value.contains(suggestedSeparator)) {
            return suggestedSeparator;
        }
        String chars = "-~=+*%#$&";
        int i = 3;
        while (i < 80) {
            int c = 0;
            while (i < "-~=+*%#$&".length()) {
                String separator = Strings.repeat((String)String.valueOf("-~=+*%#$&".charAt(c)), (int)i);
                if (!value.contains(separator)) {
                    return separator;
                }
                ++c;
            }
            ++i;
        }
        throw new IllegalStateException();
    }

    public XpectArgument getArgument() {
        return this.argument;
    }

    public String getExpectation() {
        if (this.region.getLength() < 0) {
            return "";
        }
        Text substring = new Text(this.region.getDocument().toString().substring(this.region.getOffset(), this.region.getOffset() + this.region.getLength()));
        if (this.region instanceof IMultiLineExpectationRegion) {
            String indentation = ((IMultiLineExpectationRegion)this.region).getIndentation();
            List<String> lines = substring.splitIntoLines();
            Object[] newLines = new String[lines.size()];
            int i = 0;
            while (i < lines.size()) {
                newLines[i] = lines.get(i).startsWith(indentation) ? lines.get(i).substring(indentation.length()) : lines.get(i);
                ++i;
            }
            return Joiner.on((String)substring.getNL()).join(newLines);
        }
        return substring.getText().toString();
    }

    public IExpectationRegion getRegion() {
        return this.region;
    }

    protected IReplacement getReplacement(Text value, boolean enforceMultiLine) {
        Text document = new Text(this.region.getDocument());
        if (this.region instanceof IMultiLineExpectationRegion) {
            IMultiLineExpectationRegion mlRegion = (IMultiLineExpectationRegion)this.region;
            String indentation = mlRegion.getIndentation();
            String separator = this.findValidSeparator(value.toString(), mlRegion.getSeparator());
            int sepOpening = mlRegion.getOpeningSeparatorOffset();
            int sepClosing = mlRegion.getClosingSeparatorOffset();
            String betweenSeparatorAndExpectation = document.substring(sepOpening + mlRegion.getSeparator().length(), mlRegion.getOffset());
            String betweenExpectationAndSeparator = document.substring(mlRegion.getOffset() + mlRegion.getLength(), sepClosing);
            String indented = String.valueOf(indentation) + value.indentWith(indentation);
            StringBuilder builder = new StringBuilder();
            builder.append(separator);
            builder.append(betweenSeparatorAndExpectation);
            builder.append(indented);
            builder.append(betweenExpectationAndSeparator);
            builder.append(separator);
            return new Replacement(document.getText(), sepOpening, sepClosing + mlRegion.getSeparator().length() - sepOpening, builder.toString());
        }
        if (this.region instanceof ISingleLineExpectationRegion) {
            ISingleLineExpectationRegion slRegion = (ISingleLineExpectationRegion)this.region;
            if (enforceMultiLine) {
                String separator = this.findValidSeparator(value.toString(), null);
                String indentation = document.findIndentation(slRegion.getOpeningSeparatorOffset());
                String insideIndentation = indentation;
                if (insideIndentation.length() > 0) {
                    char first = insideIndentation.charAt(0);
                    insideIndentation = first == '\t' ? String.valueOf(insideIndentation) + first : String.valueOf(insideIndentation) + first + first + first + first;
                }
                String indented = String.valueOf(insideIndentation) + value.indentWith(insideIndentation);
                StringBuilder builder = new StringBuilder();
                builder.append(separator);
                builder.append(document.getNL());
                builder.append(indented);
                builder.append(document.getNL());
                builder.append(indentation);
                builder.append(separator);
                int length = slRegion.getOffset() - slRegion.getOpeningSeparatorOffset() + slRegion.getLength();
                return new Replacement(document.getText(), slRegion.getOpeningSeparatorOffset(), length, builder.toString());
            }
            return new Replacement(document.getText(), this.region.getOffset(), this.region.getLength(), value.toString());
        }
        throw new IllegalStateException();
    }

    public TargetSyntaxSupport getTargetSyntax() {
        return this.targetSyntax;
    }

    public TargetSyntaxSupport.TargetLiteralSupport getTargetSyntaxLiteral() {
        return this.targetLiteral;
    }

    protected String replaceInDocument(String newValue) {
        Text document = new Text(this.region.getDocument());
        Text value = new Text(newValue);
        boolean multiline = this.targetSyntax.supportsMultiLineLiteral() && value.isMultiline();
        IReplacement replacement = this.getReplacement(value, multiline);
        IReplacement targetReplacement = this.targetLiteral.adoptToTargetSyntax(replacement, multiline);
        return document.with(targetReplacement);
    }
}

