/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.util;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import io.github.classgraph.ClassGraph;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.jar.Manifest;
import org.apache.log4j.Logger;
import org.eclipse.xpect.runner.XpectRunner;

public class ClasspathUtil {
    private static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static final Logger LOG = Logger.getLogger(ClasspathUtil.class);

    public static Collection<URL> findResources(String ... fileNames) {
        LinkedHashSet result;
        block22: {
            result = Sets.newLinkedHashSet();
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            try {
                String[] stringArray = fileNames;
                int n = fileNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String fileName = stringArray[n2];
                    Enumeration<URL> resources = classLoader.getResources(fileName);
                    while (resources.hasMoreElements()) {
                        result.add(resources.nextElement());
                    }
                    ++n2;
                }
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            List urls = new ClassGraph().getClasspathURLs();
            if (!urls.isEmpty()) {
                block10: for (URL u : urls) {
                    if (u.getFile().endsWith(".jar")) continue;
                    try {
                        File f = new File(u.toURI());
                        if (!f.isDirectory()) continue;
                        int levels = 5;
                        while (levels >= 0 && f != null) {
                            String[] stringArray = fileNames;
                            int n = fileNames.length;
                            int n3 = 0;
                            while (n3 < n) {
                                String fileName = stringArray[n3];
                                File pl = new File(f + "/" + fileName);
                                if (pl.isFile()) {
                                    result.add(pl.toURI().toURL());
                                    continue block10;
                                }
                                ++n3;
                            }
                            --levels;
                            f = f.getParentFile();
                        }
                    }
                    catch (URISyntaxException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (MalformedURLException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            if (XpectRunner.INSTANCE != null) {
                Class clazz = XpectRunner.INSTANCE.getTestClass().getJavaClass();
                Object[] segments = clazz.getName().split("\\.");
                String fileName = String.valueOf(Joiner.on((char)'/').join(segments)) + ".class";
                URL resource = clazz.getClassLoader().getResource(fileName);
                if (!"jar".equals(resource.getProtocol())) {
                    try {
                        File classFile;
                        File packageRootFolder = classFile = new File(resource.toURI());
                        int i = 0;
                        while (i < segments.length) {
                            if ((packageRootFolder = packageRootFolder.getParentFile()) == null) {
                                LOG.error((Object)("Could not determine package root for " + clazz));
                            }
                            ++i;
                        }
                        File current = packageRootFolder;
                        while (current != null) {
                            String[] stringArray = fileNames;
                            int n = fileNames.length;
                            int n4 = 0;
                            while (n4 < n) {
                                String name = stringArray[n4];
                                File pl = new File(current, name);
                                if (pl.isFile()) {
                                    result.add(pl.toURI().toURL());
                                    break block22;
                                }
                                ++n4;
                            }
                            current = current.getParentFile();
                        }
                    }
                    catch (URISyntaxException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (MalformedURLException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    public static String getSymbolicName(InputStream manifestInputStream) {
        try {
            Manifest manifest = new Manifest(manifestInputStream);
            String string = ClasspathUtil.getSymbolicName(manifest);
            return string;
        }
        catch (IOException e) {
            LOG.error((Object)"error parsing manifest", (Throwable)e);
        }
        finally {
            try {
                Closeables.close((Closeable)manifestInputStream, (boolean)true);
            }
            catch (IOException e) {
                LOG.error((Object)"error parsing manifest", (Throwable)e);
            }
        }
        return null;
    }

    public static String getSymbolicName(Manifest manifest) {
        int i;
        String name = manifest.getMainAttributes().getValue(BUNDLE_SYMBOLIC_NAME);
        if (name != null && (i = name.indexOf(59)) >= 0) {
            name = name.substring(0, i);
        }
        return name;
    }
}

