/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.postprocessing;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4idl.versioning.MigrationUtils;
import org.eclipse.n4js.postprocessing.ASTFlowInfo;
import org.eclipse.n4js.postprocessing.ASTMetaInfoCache;
import org.eclipse.n4js.postprocessing.ASTProcessor;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.resource.PostProcessingAwareResource;
import org.eclipse.n4js.scoping.N4JSScopeProvider;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.typesystem.utils.TypeSystemHelper;
import org.eclipse.n4js.utils.EcoreUtilN4;
import org.eclipse.n4js.utils.TameAutoClosable;
import org.eclipse.n4js.utils.UtilN4;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;

public class N4JSPostProcessor
implements PostProcessingAwareResource.PostProcessor {
    @Inject
    private ASTProcessor astProcessor;
    @Inject
    private OperationCanceledManager operationCanceledManager;
    @Inject
    private TypeSystemHelper typeSystemHelper;
    @Inject
    private JavaScriptVariantHelper jsVariantHelper;
    @Inject
    private N4JSScopeProvider n4jsScopeProvider;

    @Override
    public boolean expectsLazyLinkResolution() {
        return false;
    }

    @Override
    public void performPostProcessing(PostProcessingAwareResource resource, CancelIndicator cancelIndicator) {
        N4JSResource resourceCasted = (N4JSResource)resource;
        ASTMetaInfoCache cache = this.createASTMetaInfoCache(resourceCasted);
        try {
            try {
                this.postProcessN4JSResource(resourceCasted, cancelIndicator);
            }
            catch (Throwable th) {
                this.operationCanceledManager.propagateIfCancelException(th);
                if (!cache.hasBrokenAST()) {
                    UtilN4.reportError((String)("exception while post-processing resource " + resource.getURI()), (Throwable)th);
                    throw th;
                }
                cache.clearTemporaryPostProcessingData();
            }
        }
        finally {
            cache.clearTemporaryPostProcessingData();
        }
    }

    @Override
    public void discardPostProcessingResult(PostProcessingAwareResource resource) {
        ((N4JSResource)resource).setASTMetaInfoCache(null);
    }

    private ASTMetaInfoCache createASTMetaInfoCache(N4JSResource resource) {
        boolean hasBrokenAST = !resource.getErrors().isEmpty();
        ASTFlowInfo flowInfo = new ASTFlowInfo(this.typeSystemHelper, this.jsVariantHelper);
        ASTMetaInfoCache newCache = new ASTMetaInfoCache(resource, hasBrokenAST, flowInfo);
        resource.setASTMetaInfoCache(newCache);
        return newCache;
    }

    private void postProcessN4JSResource(N4JSResource resource, CancelIndicator cancelIndicator) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TameAutoClosable tac = this.n4jsScopeProvider.newCrossFileResolutionSuppressor();){
            this.resolveLocalIdentifierRefs(resource);
            this.performFlowAnalysis(resource, cancelIndicator);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.astProcessor.processAST(resource, cancelIndicator);
        N4JSPostProcessor.exposeReferencedInternalTypes(resource);
        EcoreUtil.resolveAll((EObject)resource.getModule());
    }

    private void resolveLocalIdentifierRefs(N4JSResource resource) {
        Script script = resource.getScript();
        TreeIterator iter = script.eAllContents();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if (!(eObject instanceof IdentifierRef) || MigrationUtils.isMigrateCallIdentifier((IdentifierRef)eObject)) continue;
            ((IdentifierRef)eObject).getId();
        }
    }

    private void performFlowAnalysis(N4JSResource resource, CancelIndicator cancelIndicator) {
        Script script = resource.getScript();
        ASTMetaInfoCache cache = resource.getASTMetaInfoCache();
        cache.getFlowInfo().createGraphs(script, () -> ((CancelIndicator)cancelIndicator).isCanceled());
        cache.getFlowInfo().performForwardAnalysis(() -> ((CancelIndicator)cancelIndicator).isCanceled());
    }

    private static void exposeReferencedInternalTypes(N4JSResource res) {
        TModule module = res.getModule();
        if (module == null) {
            return;
        }
        module.getInternalTypes().addAll((Collection)module.getExposedInternalTypes());
        ArrayList stuffToScan = new ArrayList();
        stuffToScan.addAll(module.getTopLevelTypes());
        stuffToScan.addAll(module.getVariables());
        for (EObject currRoot : stuffToScan) {
            N4JSPostProcessor.exposeTypesReferencedBy(currRoot);
        }
    }

    private static void exposeTypesReferencedBy(EObject root) {
        TreeIterator i = root.eAllContents();
        while (i.hasNext()) {
            EObject object = (EObject)i.next();
            for (EReference currRef : object.eClass().getEAllReferences()) {
                if (currRef.isContainment() || currRef.isContainer()) continue;
                Object currTarget = object.eGet((EStructuralFeature)currRef);
                if (currTarget instanceof Collection) {
                    for (Object currObj : (Collection)currTarget) {
                        N4JSPostProcessor.exposeType(currObj);
                    }
                    continue;
                }
                N4JSPostProcessor.exposeType(currTarget);
            }
        }
    }

    private static void exposeType(Object object) {
        if (!(object instanceof EObject) || ((EObject)object).eIsProxy()) {
            return;
        }
        EObject rootTMP = (EObject)object;
        while (rootTMP != null && !(rootTMP.eContainer() instanceof TModule)) {
            rootTMP = rootTMP.eContainer();
        }
        EObject root = rootTMP;
        if (root instanceof Type && root.eContainingFeature() == TypesPackage.eINSTANCE.getTModule_InternalTypes()) {
            TModule module = (TModule)root.eContainer();
            EcoreUtilN4.doWithDeliver((boolean)false, () -> module.getExposedInternalTypes().add((Object)((Type)root)), (Object[])new Object[]{module, root});
            N4JSPostProcessor.exposeTypesReferencedBy(root);
        }
    }
}

