/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils.io;

import com.google.common.base.Joiner;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.xbase.lib.Pair;

public interface IDirectoryDiffAcceptor {
    public void missing(Path var1);

    public void unexpected(Path var1);

    public void fileInsteadOfDirectory(Path var1);

    public void directoryInsteadOfFile(Path var1);

    public void differentLength(Path var1);

    public void differentContent(Path var1, long var2);

    public static final class CollectingDirectoryDiffAcceptor
    implements IDirectoryDiffAcceptor {
        public final List<Path> unexpected = new ArrayList<Path>();
        public final List<Path> missing = new ArrayList<Path>();
        public final List<Path> fileInsteadOfDir = new ArrayList<Path>();
        public final List<Path> dirInsteadOfFile = new ArrayList<Path>();
        public final List<Path> diffLength = new ArrayList<Path>();
        public final List<Pair<Path, Long>> diffContent = new ArrayList<Pair<Path, Long>>();

        public boolean isEmpty() {
            return this.unexpected.isEmpty() && this.missing.isEmpty() && this.fileInsteadOfDir.isEmpty() && this.dirInsteadOfFile.isEmpty() && this.diffLength.isEmpty() && this.diffContent.isEmpty();
        }

        @Override
        public void unexpected(Path relPath) {
            this.unexpected.add(relPath);
        }

        @Override
        public void missing(Path relPath) {
            this.missing.add(relPath);
        }

        @Override
        public void fileInsteadOfDirectory(Path relPath) {
            this.fileInsteadOfDir.add(relPath);
        }

        @Override
        public void directoryInsteadOfFile(Path relPath) {
            this.dirInsteadOfFile.add(relPath);
        }

        @Override
        public void differentLength(Path relPath) {
            this.diffLength.add(relPath);
        }

        @Override
        public void differentContent(Path relPath, long pos) {
            this.diffContent.add((Pair<Path, Long>)new Pair((Object)relPath, (Object)pos));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.isEmpty()) {
                sb.append("No differences.");
            } else {
                boolean needNewLine = false;
                if (!this.unexpected.isEmpty()) {
                    sb.append("unexpected:\n  ");
                    sb.append(Joiner.on((String)"\n  ").join(this.unexpected));
                    needNewLine |= true;
                }
                if (!this.missing.isEmpty()) {
                    if (needNewLine) {
                        sb.append("\n");
                    }
                    sb.append("missing:\n  ");
                    sb.append(Joiner.on((String)"\n  ").join(this.missing));
                    needNewLine |= true;
                }
                if (!this.fileInsteadOfDir.isEmpty()) {
                    if (needNewLine) {
                        sb.append("\n");
                    }
                    sb.append("file instead of directory:\n  ");
                    sb.append(Joiner.on((String)"\n  ").join(this.fileInsteadOfDir));
                    needNewLine |= true;
                }
                if (!this.dirInsteadOfFile.isEmpty()) {
                    if (needNewLine) {
                        sb.append("\n");
                    }
                    sb.append("directory instead of file:\n  ");
                    sb.append(Joiner.on((String)"\n  ").join(this.dirInsteadOfFile));
                    needNewLine |= true;
                }
                if (!this.diffLength.isEmpty()) {
                    if (needNewLine) {
                        sb.append("\n");
                    }
                    sb.append("different length:\n  ");
                    sb.append(Joiner.on((String)"\n  ").join(this.diffLength));
                    needNewLine |= true;
                }
                if (!this.diffContent.isEmpty()) {
                    if (needNewLine) {
                        sb.append("\n");
                    }
                    sb.append("different content:\n  ");
                    sb.append(Joiner.on((String)"\n  ").join(this.diffContent));
                    boolean bl = needNewLine | true;
                }
            }
            return sb.toString();
        }
    }
}

