/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xtext.resourceset;

import java.lang.reflect.Field;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.n4js.xtext.resourceset.StandardResourceLocator;
import org.eclipse.xtext.resource.XtextResourceSet;

public class XtextResourceLocator
extends StandardResourceLocator {
    private static final Field normalizationMap;

    static {
        try {
            Field fld = XtextResourceSet.class.getDeclaredField("normalizationMap");
            fld.setAccessible(true);
            normalizationMap = fld;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public XtextResourceLocator(XtextResourceSet resourceSet) {
        super((ResourceSetImpl)resourceSet);
    }

    @Override
    public Resource getResource(URI uri, boolean loadOnDemand) {
        URI normalizedURI;
        Map map = this.resourceSet.getURIResourceMap();
        if (map == null) {
            return super.getResource(uri, loadOnDemand);
        }
        XtextResourceSet resourceSet = (XtextResourceSet)this.resourceSet;
        Resource resource = (Resource)map.get(uri);
        if (resource == null && (resource = (Resource)map.get(normalizedURI = resourceSet.getURIConverter().normalize(uri))) != null) {
            this.normalizedMapping(uri, normalizedURI);
        }
        if (resource != null) {
            if (loadOnDemand && !resource.isLoaded()) {
                this.demandLoadHelper(resource);
            }
            return resource;
        }
        Resource delegatedResource = this.delegatedGetResource(uri, loadOnDemand);
        if (delegatedResource != null) {
            return delegatedResource;
        }
        if (loadOnDemand) {
            resource = this.demandCreateResource(uri);
            if (resource == null) {
                throw new RuntimeException("Cannot create a resource for '" + uri + "'; a registered resource factory is needed");
            }
            this.demandLoadHelper(resource);
            return resource;
        }
        return null;
    }

    private void normalizedMapping(URI from, URI to) {
        try {
            Map map = (Map)normalizationMap.get(this.resourceSet);
            map.put(from, to);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

