/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.internal;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.concurrent.Semaphore;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.n4js.ui.N4JSUiMessages;
import org.eclipse.n4js.ui.internal.InjectorNotYetAvailableException;
import org.eclipse.n4js.ui.internal.N4JSActivator;
import org.eclipse.n4js.ui.utils.UIUtils;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.xtext.util.Modules2;

public class N4JSGracefulActivator
extends N4JSActivator {
    private final Semaphore semaphore = new Semaphore(1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Injector getInjector(String language) {
        Semaphore semaphore = this.semaphore;
        synchronized (semaphore) {
            if (this.semaphore.availablePermits() < 1) {
                throw new InjectorNotYetAvailableException();
            }
            try {
                this.semaphore.acquire();
                Injector injector = super.getInjector(language);
                return injector;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.semaphore.release();
            }
        }
    }

    @Override
    protected Injector createInjector(String language) {
        try {
            Module runtimeModule = this.getRuntimeModule(language);
            Module sharedStateModule = this.getSharedStateModule();
            Module uiModule = this.getUiModule(language);
            Module mergedModule = Modules2.mixin((Module[])new Module[]{runtimeModule, sharedStateModule, uiModule});
            return Guice.createInjector((Module[])new Module[]{mergedModule});
        }
        catch (Exception e) {
            e.printStackTrace();
            UIUtils.showError(e);
            System.exit(-1);
            return null;
        }
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = N4JSGracefulActivator.getInstance().getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static void statusDialog(IStatus status) {
        switch (status.getSeverity()) {
            case 4: {
                N4JSGracefulActivator.statusDialog(N4JSUiMessages.msgN4JSUI_ERROR_TITLE(), status);
                break;
            }
            case 2: {
                N4JSGracefulActivator.statusDialog(N4JSUiMessages.msgN4JSUI_WARNING_TITLE(), status);
                break;
            }
            case 1: {
                N4JSGracefulActivator.statusDialog(N4JSUiMessages.msgN4JSUI_INFO_TITLE(), status);
            }
        }
    }

    public static void statusDialog(String title, IStatus status) {
        Shell shell = N4JSGracefulActivator.getActiveWorkbenchShell();
        if (shell != null) {
            switch (status.getSeverity()) {
                case 4: {
                    ErrorDialog.openError((Shell)shell, (String)title, null, (IStatus)status);
                    break;
                }
                case 2: {
                    MessageDialog.openWarning((Shell)shell, (String)title, (String)status.getMessage());
                    break;
                }
                case 1: {
                    MessageDialog.openInformation((Shell)shell, (String)title, (String)status.getMessage());
                }
            }
        }
    }
}

