/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.preferences.external;

import java.util.function.Supplier;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.n4js.external.LibraryManager;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.ui.internal.N4JSActivator;
import org.eclipse.n4js.ui.preferences.external.NpmNameAndVersionValidatorHelper;
import org.eclipse.n4js.ui.utils.UIUtils;
import org.eclipse.n4js.utils.StatusHelper;
import org.eclipse.n4js.utils.StatusUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class UninstallNpmDependencyButtonListener
extends SelectionAdapter {
    private final LibraryManager libManager;
    private final NpmNameAndVersionValidatorHelper validatorHelper;
    private final StatusHelper statusHelper;
    private final Runnable updateLocations;
    private final Supplier<IN4JSProject> getSelectedNpm;

    UninstallNpmDependencyButtonListener(Runnable updateLocations, LibraryManager libManager, NpmNameAndVersionValidatorHelper validatorHelper, StatusHelper statusHelper, Supplier<IN4JSProject> getSelectedNpm) {
        this.statusHelper = statusHelper;
        this.validatorHelper = validatorHelper;
        this.libManager = libManager;
        this.updateLocations = updateLocations;
        this.getSelectedNpm = getSelectedNpm;
    }

    public void widgetSelected(SelectionEvent e) {
        block11: {
            InputDialog dialog = new InputDialog(UIUtils.getShell(), "npm Uninstall", "Specify an npm package name to uninstall:", this.getSelectedNpm.get().getProjectName().getName(), this.validatorHelper.getPackageNameToUninstallValidator());
            dialog.open();
            String packageName = dialog.getValue();
            MultiStatus multistatus = this.statusHelper.createMultiStatus("Uninstalling npm '" + packageName + "'.");
            if (StringExtensions.isNullOrEmpty((String)packageName) || dialog.getReturnCode() != 0) {
                return;
            }
            try {
                IN4JSProject npmProject = this.getSelectedNpm.get();
                new ProgressMonitorDialog(UIUtils.getShell()).run(true, true, monitor -> {
                    try {
                        FileURI location = (FileURI)npmProject.getLocation();
                        IStatus status = this.libManager.uninstallNPM(location, monitor);
                        multistatus.merge(status);
                    }
                    finally {
                        this.updateLocations.run();
                    }
                });
            }
            catch (InterruptedException | OperationCanceledException npmProject) {
                if (!multistatus.isOK()) {
                    N4JSActivator.getInstance().getLog().log((IStatus)multistatus);
                    UIUtils.getDisplay().asyncExec(() -> {
                        String descr = StatusUtils.getErrorMessage((IStatus)multistatus, (boolean)true);
                        ErrorDialog.openError((Shell)UIUtils.getShell(), (String)"NPM Uninstall Failed", (String)descr, (IStatus)multistatus);
                    });
                }
                break block11;
            }
            catch (Exception exc) {
                try {
                    String msg = "Error while uninstalling npm dependency: '" + packageName + "'.";
                    Throwable causingExc = exc.getCause() == null ? exc : exc.getCause();
                    multistatus.merge(this.statusHelper.createError(msg, causingExc));
                }
                catch (Throwable throwable) {
                    if (!multistatus.isOK()) {
                        N4JSActivator.getInstance().getLog().log((IStatus)multistatus);
                        UIUtils.getDisplay().asyncExec(() -> {
                            String descr = StatusUtils.getErrorMessage((IStatus)multistatus, (boolean)true);
                            ErrorDialog.openError((Shell)UIUtils.getShell(), (String)"NPM Uninstall Failed", (String)descr, (IStatus)multistatus);
                        });
                    }
                    throw throwable;
                }
                if (!multistatus.isOK()) {
                    N4JSActivator.getInstance().getLog().log((IStatus)multistatus);
                    UIUtils.getDisplay().asyncExec(() -> {
                        String descr = StatusUtils.getErrorMessage((IStatus)multistatus, (boolean)true);
                        ErrorDialog.openError((Shell)UIUtils.getShell(), (String)"NPM Uninstall Failed", (String)descr, (IStatus)multistatus);
                    });
                }
                break block11;
            }
            if (!multistatus.isOK()) {
                N4JSActivator.getInstance().getLog().log((IStatus)multistatus);
                UIUtils.getDisplay().asyncExec(() -> {
                    String descr = StatusUtils.getErrorMessage((IStatus)multistatus, (boolean)true);
                    ErrorDialog.openError((Shell)UIUtils.getShell(), (String)"NPM Uninstall Failed", (String)descr, (IStatus)multistatus);
                });
            }
        }
    }
}

