/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.jface.util.Geometry;
import org.eclipse.n4js.ui.utils.InterruptedRuntimeException;
import org.eclipse.n4js.ui.utils.TimeoutRuntimeException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public abstract class UIUtils {
    public static final long DEFAULT_UI_TIMEOUT = TimeUnit.SECONDS.toMillis(60L);

    public static <T> T waitForValueFromUI(NonWaitingSupplier<T> nonWaitingSupplier, Supplier<String> valueDescSupplier) {
        return UIUtils.waitForValueFromUI(nonWaitingSupplier, valueDescSupplier, DEFAULT_UI_TIMEOUT);
    }

    public static <T> T waitForValueFromUI(NonWaitingSupplier<T> nonWaitingSupplier, Supplier<String> valueDescSupplier, long timeout) {
        Optional<T> item;
        long start = System.currentTimeMillis();
        while (!(item = nonWaitingSupplier.get()).isPresent() && System.currentTimeMillis() - start < timeout) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new InterruptedRuntimeException("received interrupt while waiting for " + valueDescSupplier.get());
            }
            UIUtils.waitForUiThread();
        }
        if (!item.isPresent()) {
            throw new TimeoutRuntimeException("timed out after " + timeout + "ms while waiting for " + valueDescSupplier.get());
        }
        return item.get();
    }

    public static TreeItem waitForTreeItem(Tree root, String ... texts) {
        return UIUtils.waitForTreeItemInternal(root, texts);
    }

    public static TreeItem waitForTreeItem(TreeItem root, String ... texts) {
        return UIUtils.waitForTreeItemInternal(root, texts);
    }

    private static TreeItem waitForTreeItemInternal(Object root, String ... texts) {
        Objects.requireNonNull(root);
        Objects.requireNonNull(texts);
        Object currChild = null;
        int i = 0;
        while (i < texts.length) {
            Object currParent = currChild != null ? currChild : root;
            String currText = texts[i];
            currChild = (TreeItem)UIUtils.waitForValueFromUI(() -> UIUtils.getChildItem(currParent, currText), () -> "child item \"" + currText + "\"");
            ++i;
        }
        return currChild;
    }

    private static Optional<TreeItem> getChildItem(Object parent, String text) {
        if (parent instanceof TreeItem && !((TreeItem)parent).getExpanded()) {
            ((TreeItem)parent).setExpanded(true);
            UIUtils.waitForUiThread();
        }
        TreeItem[] currChildren = parent instanceof Tree ? ((Tree)parent).getItems() : ((TreeItem)parent).getItems();
        return Stream.of(currChildren).filter(child -> text.equals(child.getText())).findFirst();
    }

    public static void waitForUiThread() {
        Display display = UIUtils.getDisplay();
        display.syncExec(() -> {
            if (!display.isDisposed()) {
                while (display.readAndDispatch()) {
                }
                display.update();
            }
        });
    }

    public static void dispose(Resource resource) {
        if (resource != null && !resource.isDisposed()) {
            resource.dispose();
        }
    }

    public static void dispose(Widget widget) {
        if (widget != null && !widget.isDisposed()) {
            widget.dispose();
        }
    }

    public static Display getDisplay() {
        return Display.getCurrent() == null ? Display.getDefault() : Display.getCurrent();
    }

    public static Shell getShell() {
        Display display = UIUtils.getDisplay();
        return display == null ? null : display.getActiveShell();
    }

    public static Color getSystemColor(int swtColorConstantId) {
        return UIUtils.getDisplay().getSystemColor(swtColorConstantId);
    }

    public static Rectangle getConstrainedShellBounds(Shell shell, Point preferredSize) {
        Point location = UIUtils.getInitialLocation(shell, preferredSize);
        Rectangle result = new Rectangle(location.x, location.y, preferredSize.x, preferredSize.y);
        Monitor monitor = UIUtils.getClosestMonitor(shell.getDisplay(), Geometry.centerPoint((Rectangle)result));
        Rectangle bounds = monitor.getClientArea();
        if (result.height > bounds.height) {
            result.height = bounds.height;
        }
        if (result.width > bounds.width) {
            result.width = bounds.width;
        }
        result.x = Math.max(bounds.x, Math.min(result.x, bounds.x + bounds.width - result.width));
        result.y = Math.max(bounds.y, Math.min(result.y, bounds.y + bounds.height - result.height));
        return result;
    }

    public static Point getInitialLocation(Shell shell, Point initialSize) {
        Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        Monitor monitor = shell.getDisplay().getPrimaryMonitor();
        if (parent != null) {
            monitor = parent.getMonitor();
        }
        Rectangle monitorBounds = monitor.getClientArea();
        Point centerPoint = parent != null ? Geometry.centerPoint((Rectangle)parent.getBounds()) : Geometry.centerPoint((Rectangle)monitorBounds);
        return new Point(centerPoint.x - initialSize.x / 2, Math.max(monitorBounds.y, Math.min(centerPoint.y - initialSize.y * 2 / 3, monitorBounds.y + monitorBounds.height - initialSize.y)));
    }

    private static Monitor getClosestMonitor(Display toSearch, Point toFind) {
        int closest = Integer.MAX_VALUE;
        Monitor[] monitors = toSearch.getMonitors();
        Monitor result = monitors[0];
        int index = 0;
        while (index < monitors.length) {
            Monitor current = monitors[index];
            Rectangle clientArea = current.getClientArea();
            if (clientArea.contains(toFind)) {
                return current;
            }
            int distance = Geometry.distanceSquared((Point)Geometry.centerPoint((Rectangle)clientArea), (Point)toFind);
            if (distance < closest) {
                closest = distance;
                result = current;
            }
            ++index;
        }
        return result;
    }

    private UIUtils() {
    }

    public static void showError(Throwable t) {
        int dialogW = 400;
        int dialogH = 300;
        Display display = new Display();
        Shell shell = new Shell(display);
        Rectangle bounds = display.getPrimaryMonitor().getBounds();
        shell.setLocation(bounds.width / 2 - dialogW / 2, bounds.height / 2 - dialogH / 2);
        shell.setText("Fatal Error with Dependency Injection.");
        shell.setSize(dialogW, dialogH);
        shell.setLayout((Layout)new FillLayout());
        Text text = new Text((Composite)shell, 2818);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        String sStackTrace = sw.toString();
        text.setText(sStackTrace);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public static boolean runsInUIThread() {
        AtomicReference refUIThread = new AtomicReference();
        UIUtils.getDisplay().syncExec(() -> refUIThread.set(Thread.currentThread()));
        return Thread.currentThread().equals(refUIThread.get());
    }

    public static interface NonWaitingSupplier<T> {
        public Optional<T> get();
    }
}

