/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server.concurrent;

import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;
import org.eclipse.n4js.ide.xtext.server.concurrent.XAbstractRequest;
import org.eclipse.n4js.ide.xtext.server.concurrent.XRequestManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.Functions;

public class XReadRequest<V>
extends XAbstractRequest<V> {
    private static final Logger LOG = Logger.getLogger(XReadRequest.class);
    private final Functions.Function1<? super CancelIndicator, ? extends V> cancellable;
    private final ExecutorService executor;

    public XReadRequest(XRequestManager requestManager, Functions.Function1<? super CancelIndicator, ? extends V> cancellable, ExecutorService executor) {
        super(requestManager);
        this.cancellable = cancellable;
        this.executor = executor;
    }

    @Override
    public void run() {
        if (this.result.isCancelled()) {
            return;
        }
        this.executor.submit(() -> {
            try {
                this.cancelIndicator.checkCanceled();
                this.result.complete(this.cancellable.apply((Object)this.cancelIndicator));
            }
            catch (Throwable t) {
                if (!this.requestManager.isCancelException(t)) {
                    LOG.error((Object)"Error during request: ", t);
                }
                this.result.completeExceptionally(t);
            }
        });
    }
}

