/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.conversion;

import org.eclipse.n4js.conversion.N4JSValueConverterWithValueException;
import org.eclipse.n4js.conversion.ValueConverterUtils;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xtext.conversion.impl.STRINGValueConverter;
import org.eclipse.xtext.nodemodel.INode;

public abstract class AbstractN4JSStringValueConverter
extends STRINGValueConverter {
    public static final String WARN_ISSUE_CODE = "N4JSStringValueConverter.bad.escapement.warn";
    public static final String ERROR_ISSUE_CODE = "N4JSStringValueConverter.bad.escapement.error";

    protected String toEscapedString(String value) {
        return String.valueOf(this.getLeftDelimiter()) + ValueConverterUtils.convertToEscapedString(value, false) + this.getRightDelimiter();
    }

    protected abstract String getRightDelimiter();

    protected abstract String getLeftDelimiter();

    public static String convertFromN4JSString(String n4jsString, INode node, boolean validate) {
        ValueConverterUtils.StringConverterResult result = ValueConverterUtils.convertFromEscapedString(n4jsString, true, false, false, null);
        if (validate) {
            if (result.hasError()) {
                throw new BadEscapementException(IssueCodes.getMessageForVCO_STRING_BAD_ESCAP_ERROR(), "VCO_STRING_BAD_ESCAP_ERROR", node, result.getValue(), true);
            }
            if (result.hasWarning()) {
                throw new BadEscapementException(IssueCodes.getMessageForVCO_STRING_BAD_ESCAP_WARN(), "VCO_STRING_BAD_ESCAP_WARN", node, result.getValue(), false);
            }
        }
        return result.getValue();
    }

    public static boolean hasOctalEscapeSequence(String nodeText) {
        int last;
        if (nodeText.length() <= 2) {
            return false;
        }
        char[] charArray = nodeText.toCharArray();
        if (charArray[last = charArray.length - 1] == charArray[0]) {
            int idx = 1;
            while (idx < last - 1) {
                char c = charArray[idx];
                if (c == '\\') {
                    char third;
                    char next = charArray[idx + 1];
                    if (next == '\\') {
                        ++idx;
                    } else if ('0' == next ? idx + 1 < last - 1 && '0' <= (third = charArray[idx + 2]) && '9' >= third : '1' <= next && '9' >= next) {
                        return true;
                    }
                }
                ++idx;
            }
        }
        return false;
    }

    public static class BadEscapementException
    extends N4JSValueConverterWithValueException {
        private static final long serialVersionUID = 1L;
        private final boolean error;

        public BadEscapementException(String message, String issueCode, INode node, String value, boolean error) {
            super(message, issueCode, node, value, null);
            this.error = error;
        }

        public boolean isError() {
            return this.error;
        }
    }
}

