/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.n4idl.versioning;

import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TMigration;
import org.eclipse.xtext.EcoreUtil2;

public class MigrationUtils {
    private MigrationUtils() {
    }

    public static boolean isMigrationDefinition(FunctionDefinition functionDef) {
        return functionDef instanceof FunctionDeclaration && AnnotationDefinition.MIGRATION.hasAnnotation((AnnotableElement)functionDef);
    }

    public static boolean isInMigration(EObject context) {
        return MigrationUtils.getMigrationDeclaration(context).isPresent();
    }

    public static Optional<FunctionDeclaration> getMigrationDeclaration(EObject context) {
        Iterable functionDeclarationContainers = Iterables.filter((Iterable)EcoreUtil2.getAllContainers((EObject)context), FunctionDeclaration.class);
        Iterable migrationContainers = Iterables.filter((Iterable)functionDeclarationContainers, MigrationUtils::isMigrationDefinition);
        Iterator iterator = migrationContainers.iterator();
        return iterator.hasNext() ? Optional.of((FunctionDeclaration)iterator.next()) : Optional.empty();
    }

    public static Optional<TMigration> getTMigrationOf(EObject context) {
        TFunction definedFunction;
        Optional<FunctionDeclaration> migrationContainer = MigrationUtils.getMigrationDeclaration(context);
        if (migrationContainer.isPresent() && (definedFunction = migrationContainer.get().getDefinedFunction()) instanceof TMigration) {
            return Optional.of((TMigration)definedFunction);
        }
        return Optional.empty();
    }

    public static boolean isMigrateCall(EObject object) {
        return object instanceof ParameterizedCallExpression && ((ParameterizedCallExpression)object).getTarget() instanceof IdentifierRef && "migrate".equals(((IdentifierRef)((ParameterizedCallExpression)object).getTarget()).getIdAsText());
    }

    public static boolean isMigrateCallIdentifier(IdentifierRef identifierRef) {
        return MigrationUtils.isMigrateCall(identifierRef.eContainer()) && identifierRef.eContainingFeature() == N4JSPackage.Literals.EXPRESSION_WITH_TARGET__TARGET;
    }
}

