/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Singleton;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.TAnnotation;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TVariable;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.utils.Result;
import org.eclipse.n4js.validation.N4JSElementKeywordProvider;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class ValidatorMessageHelper {
    @Inject
    @Extension
    protected N4JSElementKeywordProvider _n4JSElementKeywordProvider;

    public String descriptionDifferentFrom(TMember member, TMember differentMembers) {
        return this.descriptionDifferentFrom(member, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TMember[]{differentMembers})));
    }

    public String descriptionDifferentFrom(TMember member, Iterable<TMember> otherMembers) {
        ICompositeNode node;
        Object _eGet;
        EObject ast;
        Functions.Function1 _function = it -> it.getContainingType().getName();
        boolean _contains = IterableExtensions.toList((Iterable)IterableExtensions.map(otherMembers, (Functions.Function1)_function)).contains(member.getContainingType().getName());
        if (_contains && (ast = (EObject)(_eGet = member.eGet((EStructuralFeature)TypesPackage.Literals.SYNTAX_RELATED_TELEMENT__AST_ELEMENT, false))) != null && !ast.eIsProxy() && (node = NodeModelUtils.getNode((EObject)ast)) != null) {
            int memberLine = node.getStartLine();
            StringConcatenation _builder = new StringConcatenation();
            String _description = this.description((EObject)member);
            _builder.append(_description);
            _builder.append(" (line ");
            _builder.append((Object)memberLine);
            _builder.append(")");
            return _builder.toString();
        }
        return this.description((EObject)member);
    }

    private String staticOrConstKeyword(TMember member) {
        if (member != null && member.isStatic()) {
            boolean _isConst;
            if (member instanceof TField && (_isConst = ((TField)member).isConst())) {
                return "const ";
            }
            return "static ";
        }
        return "";
    }

    private String prefixedKeyword(TMember member) {
        StringConcatenation _builder = new StringConcatenation();
        String _staticOrConstKeyword = this.staticOrConstKeyword(member);
        _builder.append(_staticOrConstKeyword);
        String _keyword = this._n4JSElementKeywordProvider.keyword(member);
        _builder.append(_keyword);
        return _builder.toString();
    }

    public String _description(FunctionDefinition definition) {
        StringConcatenation _builder = new StringConcatenation();
        String _keyword = this._n4JSElementKeywordProvider.keyword(definition);
        _builder.append(_keyword);
        _builder.append(" ");
        String _name = definition.getName();
        _builder.append(_name);
        return _builder.toString();
    }

    public String _description(NamedElement namedElement) {
        StringConcatenation _builder = new StringConcatenation();
        String _keyword = this._n4JSElementKeywordProvider.keyword(namedElement);
        _builder.append(_keyword);
        _builder.append(" ");
        String _name = namedElement.getName();
        _builder.append(_name);
        return _builder.toString();
    }

    public String _description(IdentifiableElement identifiableElement) {
        if (identifiableElement == null) {
            return "unknown ";
        }
        StringConcatenation _builder = new StringConcatenation();
        String _keyword = this._n4JSElementKeywordProvider.keyword(identifiableElement);
        _builder.append(_keyword);
        _builder.append(" ");
        String _name = identifiableElement.getName();
        _builder.append(_name);
        return _builder.toString();
    }

    public String _description(TMember member) {
        boolean _isConstructor = member.isConstructor();
        if (_isConstructor) {
            ContainerType container = member.getContainingType();
            String _xifexpression = null;
            _xifexpression = container instanceof TInterface ? "in" : "of";
            String preposition = _xifexpression;
            StringConcatenation _builder = new StringConcatenation();
            String _keyword = this._n4JSElementKeywordProvider.keyword(member);
            _builder.append(_keyword);
            _builder.append(" ");
            _builder.append(preposition);
            _builder.append(" ");
            String _description = null;
            if (container != null) {
                _description = this.description((EObject)container);
            }
            _builder.append(_description);
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        String _prefixedKeyword = this.prefixedKeyword(member);
        _builder_1.append(_prefixedKeyword);
        _builder_1.append(" ");
        String _shortQualifiedName = this.shortQualifiedName(member);
        _builder_1.append(_shortQualifiedName);
        return _builder_1.toString();
    }

    public String _description(TClassifier classifier) {
        StringConcatenation _builder = new StringConcatenation();
        String _keyword = this._n4JSElementKeywordProvider.keyword(classifier);
        _builder.append(_keyword);
        _builder.append(" ");
        String _name = classifier.getName();
        _builder.append(_name);
        return _builder.toString();
    }

    public String _description(IdentifierRef identifierRef) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("identifier ");
        String _idAsText = identifierRef.getIdAsText();
        _builder.append(_idAsText);
        return _builder.toString();
    }

    public String _description(EObject eObject) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<unnamed>");
        return _builder.toString();
    }

    public String shortDescription(TMember member) {
        StringConcatenation _builder = new StringConcatenation();
        String _prefixedKeyword = this.prefixedKeyword(member);
        _builder.append(_prefixedKeyword);
        _builder.append(" ");
        String _name = member.getName();
        _builder.append(_name);
        return _builder.toString();
    }

    public String shortDescription(TFunction func) {
        StringConcatenation _builder = new StringConcatenation();
        String _keyword = this._n4JSElementKeywordProvider.keyword(func);
        _builder.append(_keyword);
        _builder.append(" ");
        String _name = func.getName();
        _builder.append(_name);
        return _builder.toString();
    }

    public String shortDescription(TVariable tvar) {
        StringConcatenation _builder = new StringConcatenation();
        String _keyword = this._n4JSElementKeywordProvider.keyword(tvar);
        _builder.append(_keyword);
        _builder.append(" ");
        String _name = tvar.getName();
        _builder.append(_name);
        return _builder.toString();
    }

    public String descriptions(Iterable<? extends TMember> members) {
        boolean _tripleEquals;
        TMember last = (TMember)IterableExtensions.last(members);
        if (last == null) {
            return "";
        }
        TMember _head = (TMember)IterableExtensions.head(members);
        boolean bl = _tripleEquals = last == _head;
        if (_tripleEquals) {
            return this.description((EObject)last);
        }
        Functions.Function1 _function = it -> !Objects.equal((Object)it, (Object)last);
        Functions.Function1 _function_1 = it -> this.description((EObject)it);
        String _join = IterableExtensions.join((Iterable)IterableExtensions.filter(members, (Functions.Function1)_function), (CharSequence)"", (CharSequence)", ", (CharSequence)"", (Functions.Function1)_function_1);
        String _plus = String.valueOf(_join) + " and ";
        String _description = this.description((EObject)last);
        return String.valueOf(_plus) + _description;
    }

    public String shortQualifiedName(TMember member) {
        String _name = member.getContainingType().getName();
        String _plus = String.valueOf(_name) + ".";
        String _name_1 = member.getName();
        return String.valueOf(_plus) + _name_1;
    }

    public String shortQualifiedName(TFunction func) {
        return func.getName();
    }

    public String shortQualifiedName(TVariable tvar) {
        return tvar.getName();
    }

    public String names(Iterable<? extends IdentifiableElement> namedElements) {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> {
            IdentifiableElement _last = (IdentifiableElement)IterableExtensions.last((Iterable)namedElements);
            return it != _last;
        };
        Iterable _filter = IterableExtensions.filter(namedElements, (Functions.Function1)_function);
        boolean _hasElements = false;
        for (IdentifiableElement i : _filter) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "");
            }
            String _name = i.getName();
            _builder.append(_name);
        }
        if (_hasElements) {
            _builder.append(" and ");
        }
        String _name_1 = ((IdentifiableElement)IterableExtensions.last(namedElements)).getName();
        _builder.append(_name_1);
        return _builder.toString();
    }

    public String descriptionWithLine(TMember member) {
        String _xblockexpression = null;
        String memberLine = this.getMemberLine(member.getAstElement());
        StringConcatenation _builder = new StringConcatenation();
        String _prefixedKeyword = this.prefixedKeyword(member);
        _builder.append(_prefixedKeyword);
        _builder.append(" ");
        String _name = member.getName();
        _builder.append(_name);
        _builder.append(memberLine);
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String getMemberLine(EObject element) {
        ICompositeNode node;
        if (element != null && (node = NodeModelUtils.getNode((EObject)element)) != null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(" ");
            _builder.append("(line ");
            int _startLine = node.getStartLine();
            _builder.append((Object)_startLine, " ");
            _builder.append(")");
            return _builder.toString();
        }
        return "";
    }

    public String descriptionWithLine(EObject eAST) {
        String memberLine = this.getMemberLine(eAST);
        StringConcatenation _builder = new StringConcatenation();
        String _keyword = this._n4JSElementKeywordProvider.keyword(eAST);
        _builder.append(_keyword);
        _builder.append(memberLine);
        String result = _builder.toString();
        return result.trim();
    }

    public String descriptionWithLine(EObject eAST, String name) {
        String _xblockexpression = null;
        String memberLine = this.getMemberLine(eAST);
        StringConcatenation _builder = new StringConcatenation();
        String _keyword = this._n4JSElementKeywordProvider.keyword(eAST);
        _builder.append(_keyword);
        _builder.append(" ");
        _builder.append(name);
        _builder.append(memberLine);
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public String description(EObject eAST, String name) {
        StringConcatenation _builder = new StringConcatenation();
        String _keyword = this._n4JSElementKeywordProvider.keyword(eAST);
        _builder.append(_keyword);
        _builder.append(" ");
        _builder.append(name);
        return _builder.toString();
    }

    public String redefinitionString(TClassifier currentClassifier, TMember overriding, TMember overridden) {
        boolean _tripleEquals;
        ContainerType overriddenContainer = overridden.getContainingType();
        boolean _isAbstract = overridden.isAbstract();
        if (_isAbstract) {
            return "implemented";
        }
        if (overriddenContainer instanceof TInterface) {
            return "implemented";
        }
        ContainerType _containingType = overriding.getContainingType();
        boolean bl = _tripleEquals = _containingType == currentClassifier;
        if (_tripleEquals) {
            return "overridden";
        }
        return "inherited";
    }

    public String inheritanceString(TClassifier currentClassifier, TMember inheritedMember) {
        ContainerType container = inheritedMember.getContainingType();
        if (container instanceof TInterface) {
            return "consumed";
        }
        return "inherited";
    }

    public String trimTypesystemMessage(Result tsresult) {
        String msg;
        String _failureMessage = null;
        if (tsresult != null) {
            _failureMessage = tsresult.getFailureMessage();
        }
        if ((msg = _failureMessage) == null) {
            return "";
        }
        boolean _startsWith = msg.startsWith("failed:");
        if (_startsWith) {
            return msg.substring("failed:".length()).trim();
        }
        return msg.trim();
    }

    public String fullFunctionSignature(TFunction tfunction) {
        boolean _isAsyncOrPromise_1;
        boolean _isGeneric;
        boolean _isGenerator;
        StringBuilder strb = new StringBuilder();
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            return !Objects.equal((Object)_name, (Object)AnnotationDefinition.INTERNAL.name);
        };
        Iterable _filter = IterableExtensions.filter((Iterable)tfunction.getAnnotations(), (Functions.Function1)_function);
        for (TAnnotation a : _filter) {
            String _annotationAsString = a.getAnnotationAsString();
            _builder.append(_annotationAsString);
            _builder.append(" ");
        }
        strb.append((CharSequence)_builder);
        if (tfunction instanceof TMethod) {
            boolean _isAbstract;
            boolean _tripleNotEquals;
            MemberAccessModifier _memberAccessModifier = ((TMethod)tfunction).getMemberAccessModifier();
            boolean bl = _tripleNotEquals = _memberAccessModifier != null;
            if (_tripleNotEquals) {
                strb.append(this._n4JSElementKeywordProvider.keyword(((TMethod)tfunction).getMemberAccessModifier()));
                strb.append(" ");
            }
            if (_isAbstract = ((TMethod)tfunction).isAbstract()) {
                strb.append("abstract ");
            }
        }
        if (!(tfunction instanceof TMethod)) {
            boolean _isAsyncOrPromise = this.isAsyncOrPromise(tfunction);
            if (_isAsyncOrPromise) {
                strb.append("async ");
            }
            strb.append("function ");
        }
        if (_isGenerator = this.isGenerator(tfunction)) {
            strb.append("* ");
        }
        if (_isGeneric = tfunction.isGeneric()) {
            Functions.Function1 _function_1 = it -> it.getTypeAsString();
            String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)tfunction.getTypeVars(), (Functions.Function1)_function_1), (CharSequence)",");
            String _plus = "<" + _join;
            String _plus_1 = String.valueOf(_plus) + "> ";
            strb.append(_plus_1);
        }
        if (tfunction instanceof TMethod && (_isAsyncOrPromise_1 = this.isAsyncOrPromise(tfunction))) {
            strb.append("async ");
        }
        String _name = tfunction.getName();
        String _plus_2 = String.valueOf(_name) + "(";
        Functions.Function1 _function_2 = it -> it.getFormalParameterAsString();
        String _join_1 = IterableExtensions.join((Iterable)ListExtensions.map((List)tfunction.getFpars(), (Functions.Function1)_function_2), (CharSequence)", ");
        String _plus_3 = String.valueOf(_plus_2) + _join_1;
        String _plus_4 = String.valueOf(_plus_3) + ")";
        strb.append(_plus_4);
        strb.append(": ");
        this.appendPromisedReturnType(strb, tfunction);
        return strb.toString();
    }

    public String orList(List<String> items) {
        boolean _greaterEqualsThan;
        boolean _equals;
        boolean _isEmpty = items.isEmpty();
        if (_isEmpty) {
            return "";
        }
        int _size = items.size();
        boolean bl = _equals = _size == 1;
        if (_equals) {
            return (String)IterableExtensions.head(items);
        }
        int _size_1 = items.size();
        boolean bl2 = _greaterEqualsThan = _size_1 >= 2;
        if (_greaterEqualsThan) {
            Iterable _tail = IterableExtensions.tail(items);
            int _size_2 = items.size();
            int _minus = _size_2 - 2;
            Functions.Function1 _function = it -> it;
            StringBuilder _append = new StringBuilder().append((String)IterableExtensions.head(items)).append(IterableExtensions.join((Iterable)IterableExtensions.take((Iterable)_tail, (int)_minus), (CharSequence)", ", (CharSequence)", ", (CharSequence)"", (Functions.Function1)_function));
            String _last = (String)IterableExtensions.last(items);
            String _plus = " or " + _last;
            return _append.append(_plus).toString();
        }
        return null;
    }

    public boolean appendPromisedReturnType(StringBuilder strb, TFunction tfunction) {
        boolean async = this.isAsyncOrPromise(tfunction);
        boolean generator = this.isGenerator(tfunction);
        if (async || generator) {
            TypeRef _returnTypeRef;
            ParameterizedTypeRef ptr;
            TypeArgument asyncReturnType;
            TypeRef retType;
            EObject astElem = tfunction.getAstElement();
            boolean _matched = false;
            if (astElem instanceof FunctionDeclaration) {
                _matched = true;
                retType = ((FunctionDeclaration)astElem).getReturnTypeRef();
                if (retType != null) {
                    strb.append(retType.getTypeRefAsString());
                    return true;
                }
            }
            if (!_matched && astElem instanceof FunctionDefinition) {
                _matched = true;
                retType = ((FunctionDefinition)astElem).getReturnTypeRef();
                if (retType != null) {
                    strb.append(retType.getTypeRefAsString());
                    return true;
                }
            }
            if ((asyncReturnType = (TypeArgument)(ptr = (ParameterizedTypeRef)(_returnTypeRef = tfunction.getReturnTypeRef())).getTypeArgs().get(0)) != null) {
                boolean _isUndefined = TypeUtils.isUndefined((TypeArgument)asyncReturnType);
                if (_isUndefined) {
                    strb.append("void");
                } else {
                    strb.append(asyncReturnType.getTypeRefAsString());
                }
                return true;
            }
        } else {
            boolean _tripleNotEquals;
            TypeRef _returnTypeRef_1 = tfunction.getReturnTypeRef();
            boolean bl = _tripleNotEquals = _returnTypeRef_1 != null;
            if (_tripleNotEquals) {
                strb.append(tfunction.getReturnTypeRef().getTypeRefAsString());
                return true;
            }
        }
        return false;
    }

    private boolean isAsyncOrPromise(TFunction tfunction) {
        ResourceSet rs;
        boolean _not;
        boolean _isDeclaredAsync = tfunction.isDeclaredAsync();
        boolean bl = _not = !_isDeclaredAsync;
        if (_not) {
            return false;
        }
        Resource _eResource = tfunction.eResource();
        ResourceSet _resourceSet = null;
        if (_eResource != null) {
            _resourceSet = _eResource.getResourceSet();
        }
        if ((rs = _resourceSet) == null) {
            return false;
        }
        return TypeUtils.isPromise((TypeRef)tfunction.getReturnTypeRef(), (BuiltInTypeScope)BuiltInTypeScope.get((ResourceSet)rs));
    }

    private boolean isGenerator(TFunction tfunction) {
        ResourceSet rs;
        boolean _not;
        boolean _isDeclaredGenerator = tfunction.isDeclaredGenerator();
        boolean bl = _not = !_isDeclaredGenerator;
        if (_not) {
            return false;
        }
        Resource _eResource = tfunction.eResource();
        ResourceSet _resourceSet = null;
        if (_eResource != null) {
            _resourceSet = _eResource.getResourceSet();
        }
        if ((rs = _resourceSet) == null) {
            return false;
        }
        return TypeUtils.isGenerator((TypeRef)tfunction.getReturnTypeRef(), (BuiltInTypeScope)BuiltInTypeScope.get((ResourceSet)rs));
    }

    public String description(EObject classifier) {
        if (classifier instanceof TClassifier) {
            return this._description((TClassifier)classifier);
        }
        if (classifier instanceof IdentifierRef) {
            return this._description((IdentifierRef)classifier);
        }
        if (classifier instanceof FunctionDefinition) {
            return this._description((FunctionDefinition)classifier);
        }
        if (classifier instanceof TMember) {
            return this._description((TMember)classifier);
        }
        if (classifier instanceof IdentifiableElement) {
            return this._description((IdentifiableElement)classifier);
        }
        if (classifier instanceof NamedElement) {
            return this._description((NamedElement)classifier);
        }
        if (classifier != null) {
            return this._description(classifier);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(classifier).toString());
    }
}

