/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui.results;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Logger;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IModificationDate;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.internal.ICompareUIConstants;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.util.Exceptions;
import org.junit.ComparisonFailure;

public class N4IDEXpectCompareEditorInput
extends CompareEditorInput {
    private static final Logger LOG = Logger.getLogger(N4IDEXpectCompareEditorInput.class);
    private final IFile file;
    private final ComparisonFailure comparisonFailure;

    protected static CompareConfiguration createConfiguration(IFile file) {
        CompareConfiguration configuration = new CompareConfiguration();
        configuration.setLeftEditable(true);
        configuration.setLeftLabel("Expected Test Result" + (file != null ? " - " + file.getName() : ""));
        configuration.setRightLabel("Actual Test Result");
        configuration.setAncestorLabel("File on Disk");
        configuration.setProperty(ICompareUIConstants.PROP_ANCESTOR_VISIBLE, (Object)Boolean.FALSE);
        return configuration;
    }

    public N4IDEXpectCompareEditorInput(IFile file, ComparisonFailure cf) {
        super(N4IDEXpectCompareEditorInput.createConfiguration(file));
        Preconditions.checkNotNull((Object)file);
        this.file = file;
        this.comparisonFailure = cf;
    }

    public String getTitle() {
        return this.file.getName();
    }

    protected Object prepareInput(IProgressMonitor pm) {
        try {
            ResourceNode ancestor = new ResourceNode((IResource)this.file);
            String ancestorContent = this.getContent(ancestor);
            String leftContent = this.comparisonFailure.getExpected();
            String rightContent = this.comparisonFailure.getActual();
            if (!leftContent.equals(ancestorContent)) {
                this.getCompareConfiguration().setProperty(ICompareUIConstants.PROP_ANCESTOR_VISIBLE, (Object)Boolean.TRUE);
            }
            EditableCompareItem left = new EditableCompareItem("Left", leftContent, this.file);
            CompareItem right = new CompareItem("Right", rightContent);
            return new DiffNode(null, 15, (ITypedElement)ancestor, (ITypedElement)left, (ITypedElement)right);
        }
        catch (Throwable t) {
            LOG.error((Object)t.getMessage(), t);
            Exceptions.throwUncheckedException((Throwable)t);
            return null;
        }
    }

    private String getContent(ResourceNode ancestor) {
        try {
            return new String(ancestor.getContent(), this.file.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    protected static class CompareItem
    implements IStreamContentAccessor,
    ITypedElement,
    IModificationDate {
        private final String contents;
        private final String name;

        CompareItem(String name, String contents) {
            this.name = name;
            this.contents = contents;
        }

        public InputStream getContents() throws CoreException {
            return new ByteArrayInputStream(this.contents.getBytes());
        }

        public Image getImage() {
            return null;
        }

        public long getModificationDate() {
            return 0L;
        }

        public String getName() {
            return this.name;
        }

        public String getString() {
            return this.contents;
        }

        public String getType() {
            return "txt";
        }
    }

    protected static class EditableCompareItem
    extends CompareItem
    implements IEditableContent {
        private final IFile file;

        EditableCompareItem(String name, String contents, IFile file) {
            super(name, contents);
            this.file = file;
        }

        public boolean isEditable() {
            return this.file != null;
        }

        public ITypedElement replace(ITypedElement dest, ITypedElement src) {
            return null;
        }

        public void setContent(byte[] newContent) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(newContent);
            try {
                this.file.setContents((InputStream)inputStream, true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                LOG.error((Object)e);
            }
        }
    }
}

