/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.imports;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.scoping.imports.NonResolvingImportScope;
import org.eclipse.n4js.ts.scoping.N4TSQualifiedNameProvider;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;
import org.eclipse.xtext.scoping.impl.ImportScope;
import org.eclipse.xtext.scoping.impl.ImportedNamespaceAwareLocalScopeProvider;

public class N4JSImportedNamespaceAwareLocalScopeProvider
extends ImportedNamespaceAwareLocalScopeProvider {
    protected List<ImportNormalizer> getImportedNamespaceResolvers(EObject context, boolean ignoreCase) {
        return Collections.emptyList();
    }

    protected IScope getLocalElementsScope(IScope parent, EObject context, EReference reference) {
        return parent;
    }

    protected IScope getResourceScope(Resource res, EReference reference) {
        EObject context = (EObject)res.getContents().get(0);
        Predicate filter = p -> {
            QualifiedName name = p.getName();
            if (name.getSegmentCount() == 1) {
                String singleSegment = name.getFirstSegment();
                return !"ArgumentsType".equals(singleSegment) && !"EnumBaseType".equals(singleSegment);
            }
            return true;
        };
        IScope globalScope = this.getGlobalScope(res, reference, filter);
        List<ImportNormalizer> normalizers = this.getImplicitImports(this.isIgnoreCase(reference));
        TModule module = (TModule)res.getContents().get(1);
        if (module.isStaticPolyfillModule()) {
            normalizers.add(this.createImportedNamespaceResolver(String.valueOf(module.getQualifiedName()) + "/" + "*", false));
        }
        if (!normalizers.isEmpty()) {
            globalScope = this.createImportScope(globalScope, normalizers, null, reference.getEReferenceType(), this.isIgnoreCase(reference));
        }
        IScope resScope = this.getResourceScope(globalScope, context, reference);
        return resScope;
    }

    protected List<ImportNormalizer> getImplicitImports(boolean ignoreCase) {
        ArrayList result = Lists.newArrayList();
        result.add(this.createImportedNamespaceResolver(String.valueOf(N4TSQualifiedNameProvider.GLOBAL_NAMESPACE_SEGMENT) + "/" + "*", ignoreCase));
        return result;
    }

    protected ImportScope createImportScope(IScope parent, List<ImportNormalizer> namespaceResolvers, ISelectable importFrom, EClass type, boolean ignoreCase) {
        return new NonResolvingImportScope(namespaceResolvers, parent, importFrom, type, ignoreCase);
    }
}

