/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.builtin;

import com.google.inject.Singleton;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.scoping.builtin.GlobalObjectScope;
import org.eclipse.n4js.scoping.builtin.GlobalObjectScopeAccess;
import org.eclipse.n4js.scoping.builtin.VirtualBaseTypeScope;
import org.eclipse.n4js.scoping.builtin.VirtualBaseTypeScopeAccess;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInSchemeRegistrar;
import org.eclipse.n4js.ts.scoping.builtin.ExecutionEnvironmentDescriptor;

@Singleton
public class ScopeRegistrar
extends BuiltInSchemeRegistrar {
    public void registerScopes(ResourceSet targetResourceSet, ResourceSet builtInSchemeResourceSet) {
        super.registerScopes(targetResourceSet, builtInSchemeResourceSet);
        GlobalObjectScope globalObjectScope = GlobalObjectScope.get(builtInSchemeResourceSet);
        GlobalObjectScopeAccess.registerGlobalObjectScope(globalObjectScope, targetResourceSet);
        VirtualBaseTypeScope virtualBaseTypeScope = VirtualBaseTypeScope.get(builtInSchemeResourceSet);
        VirtualBaseTypeScopeAccess.registerVirtualBaseTypeScope(virtualBaseTypeScope, targetResourceSet);
    }

    protected void register(ResourceSet resourceSet, ExecutionEnvironmentDescriptor descriptor) {
        super.register(resourceSet, descriptor);
        GlobalObjectScope globalObjectScope = new GlobalObjectScope(descriptor);
        GlobalObjectScopeAccess.registerGlobalObjectScope(globalObjectScope, resourceSet);
        VirtualBaseTypeScope virtualBaseTypeScope = new VirtualBaseTypeScope(descriptor);
        VirtualBaseTypeScopeAccess.registerVirtualBaseTypeScope(virtualBaseTypeScope, resourceSet);
    }
}

