/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.state;

import com.google.common.base.Joiner;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xpect.state.Configuration;
import org.eclipse.xpect.state.Default;
import org.eclipse.xpect.state.Managed;
import org.eclipse.xpect.state.ManagedImpl;
import org.eclipse.xpect.state.ResolvedConfiguration;
import org.eclipse.xpect.text.CharSequences;
import org.eclipse.xpect.text.Table;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class StateContainer {
    private final ResolvedConfiguration config;
    private final State state;

    public StateContainer(ResolvedConfiguration config) {
        this.config = config;
        this.state = new State();
    }

    public StateContainer(IAcceptor<Configuration> config) {
        Configuration cfg = new Configuration("default");
        config.accept((Object)cfg);
        this.config = new ResolvedConfiguration(cfg);
        this.state = new State();
    }

    public StateContainer(StateContainer parent, ResolvedConfiguration config) {
        this.config = config;
        this.state = parent.state;
        if (parent.config != this.config.getParent()) {
            throw new IllegalStateException("Parent configs must be the same");
        }
    }

    public StateContainer(StateContainer parent, IAcceptor<Configuration> config) {
        Configuration cfg = new Configuration("default");
        config.accept((Object)cfg);
        this.config = new ResolvedConfiguration(cfg);
        this.state = parent.state;
        if (parent.config != this.config.getParent()) {
            throw new IllegalStateException("Parent configs must be the same");
        }
    }

    protected void collectDependees(FactoryInstance fact, Set<FactoryInstance> factories, Set<Instance> instances) {
        for (Instance i : fact.down) {
            if (!instances.add(i)) continue;
            this.collectDependees(i, factories, instances);
        }
    }

    protected void collectDependees(Instance instance, Set<FactoryInstance> factories, Set<Instance> instances) {
        for (FactoryInstance fi : instance.down) {
            if (!factories.add(fi)) continue;
            this.collectDependees(fi, factories, instances);
        }
    }

    protected FactoryInstance createFactory(ResolvedConfiguration.Factory factory) {
        Constructor<?> constructor = factory.getConstructor();
        Class<?>[] paramTypes = constructor.getParameterTypes();
        Object[] paramsObjects = new Object[paramTypes.length];
        Instance[] paramsInstances = new Instance[paramTypes.length];
        Annotation[][] paramAnnot = constructor.getParameterAnnotations();
        int i = 0;
        while (i < paramTypes.length) {
            paramsInstances[i] = (Instance)this.get(paramTypes[i], paramAnnot[i]);
            paramsObjects[i] = paramsInstances[i].get();
            ++i;
        }
        try {
            Object instance = constructor.newInstance(paramsObjects);
            FactoryInstance result = new FactoryInstance(factory, instance);
            Instance[] instanceArray = paramsInstances;
            int n = paramsInstances.length;
            int n2 = 0;
            while (n2 < n) {
                Instance inst = instanceArray[n2];
                inst.down.add(result);
                result.up.add(inst);
                ++n2;
            }
            return result;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Exceptions.sneakyThrow((Throwable)e.getCause());
            return null;
        }
    }

    protected Instance createInstance(ResolvedConfiguration.DerivedValue value) {
        FactoryInstance factory = this.getFactory(value.getFactory());
        try {
            Object instance = value.getMethod().invoke(factory.instance, new Object[0]);
            Instance result = this.createInstance(value, instance);
            factory.down.add(result);
            result.up = factory;
            return result;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected Instance createInstance(ResolvedConfiguration.PrimaryValue value) {
        return this.createInstance(value, value.getValue());
    }

    protected Instance createInstance(ResolvedConfiguration.Value value) {
        if (value instanceof ResolvedConfiguration.PrimaryValue) {
            return this.createInstance((ResolvedConfiguration.PrimaryValue)value);
        }
        if (value instanceof ResolvedConfiguration.DerivedValue) {
            return this.createInstance((ResolvedConfiguration.DerivedValue)value);
        }
        throw new IllegalStateException();
    }

    protected Instance createInstance(ResolvedConfiguration.Value key, Object value) {
        if (value instanceof Managed) {
            return new ManagedInstance(key, (Managed)value);
        }
        return new ValueInstance(key, value);
    }

    public <T> Managed<T> get(Class<T> expectedType, Object ... annotations) {
        return this.get(expectedType, true, annotations);
    }

    public <T> T tryGet(Class<T> expectedType, Object ... annotations) {
        Managed<T> managed = this.get(expectedType, false, annotations);
        if (managed != null) {
            return managed.get();
        }
        return null;
    }

    protected <T> Managed<T> get(Class<T> expectedType, boolean throwException, Object ... annotations) {
        if (expectedType == StateContainer.class) {
            return new ManagedInstance(null, new ManagedImpl<StateContainer>(this));
        }
        Class<? extends Annotation> annotatedWith = this.getAnnotation(annotations);
        ResolvedConfiguration.Value value = this.config.getValue(annotatedWith, expectedType);
        if (value == null) {
            if (throwException) {
                throw new IllegalStateException("Unknown key @" + annotatedWith.getName() + " " + expectedType.getName());
            }
            return null;
        }
        Instance instance = (Instance)this.state.value2instance.get(value);
        if (instance == null) {
            instance = this.createInstance(value);
            this.state.value2instance.put(value, instance);
        }
        return instance;
    }

    protected Class<? extends Annotation> getAnnotation(Object ... annotations) {
        if (annotations.length == 0) {
            return Default.class;
        }
        Object annotation = annotations[0];
        if (annotation instanceof Class) {
            return (Class)annotation;
        }
        if (annotation instanceof Annotation) {
            return ((Annotation)annotation).annotationType();
        }
        throw new IllegalStateException();
    }

    public ResolvedConfiguration getConfiguration() {
        return this.config;
    }

    protected FactoryInstance getFactory(ResolvedConfiguration.Factory factory) {
        FactoryInstance instance = (FactoryInstance)this.state.factory2instance.get(factory);
        if (instance == null) {
            instance = this.createFactory(factory);
            this.state.factory2instance.put(factory, instance);
        }
        return instance;
    }

    public void invalidate() {
        Object instance;
        LinkedHashSet factories = Sets.newLinkedHashSet();
        LinkedHashSet instances = Sets.newLinkedHashSet();
        for (ResolvedConfiguration.PrimaryValue primaryValue : this.config.getPrimaryValues()) {
            instance = (Instance)this.state.value2instance.get(primaryValue);
            if (instance == null || !instances.add(instance)) continue;
            this.collectDependees((Instance)instance, (Set<FactoryInstance>)factories, (Set<Instance>)instances);
        }
        for (ResolvedConfiguration.Factory factory : this.config.getResolvedFactories()) {
            instance = (FactoryInstance)this.state.factory2instance.get(factory);
            if (instance == null || !factories.add(instance)) continue;
            this.collectDependees((FactoryInstance)instance, (Set<FactoryInstance>)factories, (Set<Instance>)instances);
        }
        this.invalidate(factories, instances);
    }

    protected void invalidate(FactoryInstance instance, ResolvedConfiguration.DerivedValue key, Object val) {
        Method invalidator = key.getInvalidator();
        try {
            invalidator.invoke(instance.instance, val);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected void invalidate(Instance instance) {
        LinkedHashSet factories = Sets.newLinkedHashSet();
        LinkedHashSet instances = Sets.newLinkedHashSet();
        instances.add(instance);
        this.collectDependees(instance, (Set<FactoryInstance>)factories, (Set<Instance>)instances);
        this.invalidate(factories, instances);
    }

    protected void invalidate(Set<FactoryInstance> factories, Set<Instance> instances) {
        for (Instance inst : instances) {
            ResolvedConfiguration.DerivedValue derivedValue;
            Method invalidator;
            if (inst instanceof ManagedInstance) {
                ManagedInstance mi = (ManagedInstance)inst;
                mi.value.invalidate();
            }
            if (!(inst.key instanceof ResolvedConfiguration.DerivedValue) || (invalidator = (derivedValue = (ResolvedConfiguration.DerivedValue)inst.key).getInvalidator()) == null) continue;
            FactoryInstance factoryInstance = (FactoryInstance)this.state.factory2instance.get(derivedValue.getFactory());
            this.invalidate(factoryInstance, derivedValue, inst.get());
        }
        for (Instance inst : instances) {
            this.state.value2instance.remove(inst.key);
            inst.down.clear();
            if (inst.up == null) continue;
            inst.up.down.remove(inst);
        }
        for (FactoryInstance fact : factories) {
            this.state.factory2instance.remove(fact.factory);
            fact.down.clear();
            for (Instance up : fact.up) {
                up.down.remove(fact);
            }
        }
    }

    public String toString() {
        return new ToString().toString();
    }

    protected class FactoryInstance {
        private final List<Instance> down = Lists.newArrayList();
        private final List<Instance> up = Lists.newArrayList();
        private final ResolvedConfiguration.Factory factory;
        private final Object instance;

        public FactoryInstance(ResolvedConfiguration.Factory factory, Object instance) {
            this.factory = factory;
            this.instance = instance;
        }
    }

    protected abstract class Instance
    implements Managed<Object> {
        private final List<FactoryInstance> down = Lists.newArrayList();
        private FactoryInstance up = null;
        private final ResolvedConfiguration.Value key;

        public Instance(ResolvedConfiguration.Value key) {
            this.key = key;
        }

        @Override
        public void invalidate() {
            StateContainer.this.invalidate(this);
        }
    }

    protected class ManagedInstance
    extends Instance {
        private final Managed<?> value;

        public ManagedInstance(ResolvedConfiguration.Value key, Managed<?> value) {
            super(key);
            this.value = value;
        }

        @Override
        public Object get() {
            return this.value.get();
        }
    }

    protected static class State {
        private final Map<ResolvedConfiguration.Factory, FactoryInstance> factory2instance = Maps.newLinkedHashMap();
        private final Map<ResolvedConfiguration.Value, Instance> value2instance = Maps.newLinkedHashMap();

        protected State() {
        }
    }

    protected class ToString {
        private Map<ResolvedConfiguration.Value, ValueRow> rows = Maps.newHashMap();

        protected ToString() {
        }

        private void collectValues(ResolvedConfiguration cfg) {
            for (ResolvedConfiguration.Value value : cfg.getValues().values()) {
                this.rows.put(value, new ValueRow(cfg, value));
            }
            ResolvedConfiguration parent = cfg.getParent();
            if (parent != null) {
                this.collectValues(parent);
            }
        }

        private void updateCollectDependencies(ResolvedConfiguration cfg) {
            for (ResolvedConfiguration.Factory fac : cfg.getResolvedFactories()) {
                for (ResolvedConfiguration.Value value : fac.getOut()) {
                    ValueRow row = this.rows.get(value);
                    ResolvedConfiguration.Value[] valueArray = fac.getIn();
                    int n = valueArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ResolvedConfiguration.Value in = valueArray[n2];
                        row.dependencies.add(this.rows.get(in));
                        ++n2;
                    }
                }
            }
            ResolvedConfiguration parent = cfg.getParent();
            if (parent != null) {
                this.updateCollectDependencies(parent);
            }
        }

        private boolean isMoreNarrow(ResolvedConfiguration candidate, ResolvedConfiguration ref) {
            if (candidate == null || ref == null || candidate == ref) {
                return false;
            }
            ResolvedConfiguration parent = candidate.getParent();
            if (parent == ref) {
                return true;
            }
            return this.isMoreNarrow(parent, ref);
        }

        private ResolvedConfiguration updateScope(ValueRow row) {
            ResolvedConfiguration result = row.lifecycleScope;
            if (result != null) {
                return result;
            }
            result = row.declaredScope;
            for (ValueRow dependency : row.dependencies) {
                ResolvedConfiguration dep = this.updateScope(dependency);
                if (!this.isMoreNarrow(dep, result)) continue;
                result = dep;
            }
            row.lifecycleScope = result;
            return result;
        }

        public String toString() {
            this.collectValues(StateContainer.this.config);
            this.updateCollectDependencies(StateContainer.this.config);
            for (ValueRow row1 : this.rows.values()) {
                this.updateScope(row1);
            }
            ArrayList rows = Lists.newArrayList(this.rows.values());
            Collections.sort(rows);
            Table table = new Table();
            table.setRowSeparatorHeight(0);
            Table.Row header = table.addRow();
            header.addCell().setText("Key");
            header.addCell().setText("Scope");
            header.addCell().setText("Value");
            header.addCell().setText("Dependencies");
            header.getBottomSeparator().setHeight(1).setBackground("-");
            for (ValueRow vr : rows) {
                Table.Row row = table.addRow();
                row.addCell().setText(vr.getKeyString());
                row.addCell().setText(vr.getScopeString());
                row.addCell().setText(vr.getInstanceString());
                row.addCell().setText(vr.getDependenciesString());
            }
            return table.toString();
        }

        protected class ValueRow
        implements Comparable<ValueRow> {
            private final ResolvedConfiguration.Value value;
            private final String keyType;
            private final String keyAnnotation;
            private final ResolvedConfiguration declaredScope;
            private ResolvedConfiguration lifecycleScope = null;
            private Set<ValueRow> dependencies = Sets.newHashSet();

            public ValueRow(ResolvedConfiguration scope, ResolvedConfiguration.Value value) {
                this.declaredScope = scope;
                this.value = value;
                this.keyType = value.getType() == null ? "null" : value.getType().getName();
                this.keyAnnotation = value.getAnnotatedWith().getSimpleName();
            }

            public String getInstanceString() {
                if (this.value instanceof ResolvedConfiguration.PrimaryValue) {
                    return CharSequences.toSingleLineString(((ResolvedConfiguration.PrimaryValue)this.value).getValue(), 80);
                }
                Instance instance = (Instance)StateContainer.this.state.value2instance.get(this.value);
                if (instance == null) {
                    return "(not created)";
                }
                Object object = instance.get();
                if (object == null) {
                    return "(null)";
                }
                return CharSequences.toSingleLineString(object, 80);
            }

            @Override
            public int compareTo(ValueRow o) {
                return ComparisonChain.start().compare((Comparable)((Object)this.keyType), (Comparable)((Object)o.keyType)).compare((Comparable)((Object)this.keyAnnotation), (Comparable)((Object)this.keyAnnotation)).result();
            }

            public String getKeyString() {
                if (Default.class.getSimpleName().equals(this.keyAnnotation)) {
                    return this.keyType;
                }
                return "@" + this.keyAnnotation + " " + this.keyType;
            }

            public Object getDependenciesString() {
                ArrayList dependencies = Lists.newArrayList(this.dependencies);
                Collections.sort(dependencies);
                ArrayList result = Lists.newArrayList();
                for (ValueRow val : dependencies) {
                    result.add(val.getKeyString());
                }
                return Joiner.on((String)", ").join((Iterable)result);
            }

            public Object getScopeString() {
                if (this.lifecycleScope != null) {
                    return this.lifecycleScope.getName();
                }
                return this.declaredScope.getName();
            }
        }
    }

    protected class ValueInstance
    extends Instance {
        private final Object value;

        public ValueInstance(ResolvedConfiguration.Value key, Object value) {
            super(key);
            this.value = value;
        }

        @Override
        public Object get() {
            return this.value;
        }
    }
}

