/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.versions;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.TMigratable;
import org.eclipse.n4js.ts.types.TMigration;
import org.eclipse.n4js.ts.versions.VersionableUtils;

public class MigratableUtils {
    public static String getMigrationCandidatesList(Iterable<TMigration> candidates) {
        return StreamSupport.stream(candidates.spliterator(), false).distinct().sorted((m1, m2) -> m1.getName().compareTo(m2.getName())).map(c -> "\n\t - " + c.getMigrationAsString()).collect(Collectors.joining());
    }

    public static Optional<TMigratable> findPrincipalMigrationArgument(List<TypeRef> argumentTypeRefs) {
        return argumentTypeRefs.stream().flatMap(s -> VersionableUtils.streamVersionedSubReferences(s)).map(ref -> ref.getDeclaredType()).filter(t -> t instanceof TMigratable).map(t -> (TMigratable)((Object)t)).findFirst();
    }

    public static String getMigrationArgumentsDescription(List<TypeRef> argumentTypeRefs) {
        return String.format("(%s)", argumentTypeRefs.stream().map(ref -> ref.getTypeRefAsString()).collect(Collectors.joining(", ")));
    }
}

