/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.compare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.xtext.xbase.lib.Pair;

public class ApiImplMapping {
    private final Map<N4JSProjectName, ApiImplAssociation> assocs = new LinkedHashMap<N4JSProjectName, ApiImplAssociation>();
    private final Set<IN4JSProject> projectsWithUndefImplIds = new LinkedHashSet<IN4JSProject>();
    private final Map<Pair<N4JSProjectName, N4JSProjectName>, Set<IN4JSProject>> conflicts = new LinkedHashMap<Pair<N4JSProjectName, N4JSProjectName>, Set<IN4JSProject>>();

    public static ApiImplMapping of(IN4JSCore n4jsCore) {
        ApiImplMapping mapping = new ApiImplMapping();
        n4jsCore.findAllProjects().forEach(pImpl -> pImpl.getImplementedProjects().forEach(pApi -> mapping.put((IN4JSProject)pApi, (IN4JSProject)pImpl)));
        return mapping;
    }

    public static ApiImplMapping of(Iterable<IN4JSProject> projects) {
        return ApiImplMapping.of(projects, projects);
    }

    public static ApiImplMapping of(Iterable<? extends IN4JSProject> apiProjects, Iterable<? extends IN4JSProject> implProjects) {
        return new ApiImplMapping().enhance(apiProjects, implProjects);
    }

    public ApiImplMapping enhance(Iterable<? extends IN4JSProject> apiProjects, Iterable<? extends IN4JSProject> implProjects) {
        Set apiProjectsIds = StreamSupport.stream(apiProjects.spliterator(), false).map(p -> p.getProjectName()).collect(Collectors.toSet());
        for (IN4JSProject iN4JSProject : implProjects) {
            for (IN4JSProject pApi : iN4JSProject.getImplementedProjects()) {
                if (!apiProjectsIds.contains(pApi.getProjectName())) continue;
                this.put(pApi, iN4JSProject);
            }
        }
        return this;
    }

    public void put(IN4JSProject api, IN4JSProject impl) {
        IN4JSProject replaced;
        N4JSProjectName apiId = api.getProjectName();
        if (apiId == null) {
            return;
        }
        N4JSProjectName implId = (N4JSProjectName)impl.getImplementationId().orNull();
        if (implId == null) {
            this.projectsWithUndefImplIds.add(impl);
            return;
        }
        ApiImplAssociation assoc = this.assocs.get(apiId);
        if (assoc == null) {
            assoc = new ApiImplAssociation(api);
            this.assocs.put(apiId, assoc);
        }
        if ((replaced = assoc.putImpl(impl)) != null && !Objects.equals(replaced, impl)) {
            this.putConflict(apiId, implId, replaced, impl);
        }
    }

    private void putConflict(N4JSProjectName apiId, N4JSProjectName implId, IN4JSProject ... culprit) {
        Pair apiId_implId = new Pair((Object)apiId, (Object)implId);
        Set<IN4JSProject> culprits = this.conflicts.get(apiId_implId);
        if (culprits == null) {
            culprits = new LinkedHashSet<IN4JSProject>();
            this.conflicts.put((Pair<N4JSProjectName, N4JSProjectName>)apiId_implId, culprits);
        }
        culprits.addAll(Arrays.asList(culprit));
    }

    public boolean hasErrors() {
        return !this.projectsWithUndefImplIds.isEmpty() || !this.conflicts.isEmpty();
    }

    public List<String> getErrorMessages() {
        ArrayList<String> msgs = new ArrayList<String>();
        for (IN4JSProject iN4JSProject : this.projectsWithUndefImplIds) {
            msgs.add("project '" + iN4JSProject.getProjectName() + "' does not define an ImplementationId in its manifest");
        }
        for (Map.Entry entry : this.conflicts.entrySet()) {
            N4JSProjectName apiId = (N4JSProjectName)((Pair)entry.getKey()).getKey();
            N4JSProjectName implId = (N4JSProjectName)((Pair)entry.getKey()).getValue();
            Set culprits = (Set)entry.getValue();
            String culpritsStr = " - " + culprits.stream().map(c -> c.getProjectName().getRawName()).collect(Collectors.joining("\n - "));
            msgs.add("several projects define an implementation for API project '" + apiId + "' with implementation ID '" + implId + "':\n" + culpritsStr);
        }
        return msgs;
    }

    public boolean isEmpty() {
        return this.assocs.isEmpty();
    }

    public List<N4JSProjectName> getApiIds() {
        ArrayList<N4JSProjectName> allApiIds = new ArrayList<N4JSProjectName>(this.assocs.keySet());
        Collections.sort(allApiIds);
        return allApiIds;
    }

    public List<N4JSProjectName> getAllImplIds() {
        ArrayList<N4JSProjectName> allImplIds = new ArrayList<N4JSProjectName>(this.assocs.values().stream().flatMap(p -> p.getImplIds().stream()).collect(Collectors.toSet()));
        Collections.sort(allImplIds);
        return allImplIds;
    }

    public boolean isApi(N4JSProjectName projectName) {
        return this.assocs.containsKey(projectName);
    }

    public IN4JSProject getApi(N4JSProjectName apiProjectName) {
        ApiImplAssociation assoc = this.assocs.get(apiProjectName);
        return assoc != null ? assoc.api : null;
    }

    public Collection<IN4JSProject> getImpls(N4JSProjectName apiProjectName) {
        ApiImplAssociation pair = this.assocs.get(apiProjectName);
        return pair != null ? pair.getImpls() : Collections.emptyList();
    }

    public Set<N4JSProjectName> getImplIds(N4JSProjectName apiProjectName) {
        ApiImplAssociation pair = this.assocs.get(apiProjectName);
        return pair != null ? pair.getImplIds() : Collections.emptySet();
    }

    public IN4JSProject getImpl(N4JSProjectName apiProjectName, N4JSProjectName implId) {
        ApiImplAssociation pair = this.assocs.get(apiProjectName);
        return pair != null ? pair.getImpl(implId) : null;
    }

    private static final class ApiImplAssociation {
        public final IN4JSProject api;
        public final Map<N4JSProjectName, IN4JSProject> impls = new LinkedHashMap<N4JSProjectName, IN4JSProject>();

        public ApiImplAssociation(IN4JSProject api) {
            this.api = api;
        }

        public Set<N4JSProjectName> getImplIds() {
            return this.impls.keySet();
        }

        public Collection<IN4JSProject> getImpls() {
            return this.impls.values();
        }

        public IN4JSProject getImpl(N4JSProjectName implId) {
            return this.impls.get(implId);
        }

        public IN4JSProject putImpl(IN4JSProject impl) {
            N4JSProjectName implId = (N4JSProjectName)impl.getImplementationId().orNull();
            if (implId != null) {
                return this.impls.put(implId, impl);
            }
            return null;
        }
    }
}

