/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.compare;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.n4js.compare.ProjectComparisonEntry;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;

public class ProjectComparison {
    final N4JSProjectName[] implIds;
    final List<ProjectComparisonEntry> entries = new ArrayList<ProjectComparisonEntry>();
    final Map<Object, ProjectComparisonEntry> objToEntry = new HashMap<Object, ProjectComparisonEntry>();

    public ProjectComparison(N4JSProjectName[] implIds) {
        if (implIds == null) {
            throw new IllegalArgumentException();
        }
        this.implIds = implIds;
    }

    public int getImplCount() {
        return this.implIds.length;
    }

    public N4JSProjectName[] getImplIds() {
        return this.implIds;
    }

    public N4JSProjectName getImplId(int implIndex) {
        return this.implIds != null && implIndex >= 0 && implIndex < this.implIds.length ? this.implIds[implIndex] : null;
    }

    public int getImplIndex(N4JSProjectName implId) {
        int idx = 0;
        while (idx < this.implIds.length) {
            if (implId.equals(this.implIds[idx])) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    void internalAddRootEntry(ProjectComparisonEntry entry) {
        this.entries.add(entry);
    }

    void onEntryAdded(ProjectComparisonEntry addedEntry) {
        this.objToEntry.put(addedEntry.getProjectOrElementApi(), addedEntry);
        int len = addedEntry.getImplCount();
        int idx = 0;
        while (idx < len) {
            this.objToEntry.put(addedEntry.getProjectOrElementImpl(idx), addedEntry);
            ++idx;
        }
    }

    public ProjectComparisonEntry[] getEntries() {
        return this.entries.toArray(new ProjectComparisonEntry[this.entries.size()]);
    }

    public Stream<ProjectComparisonEntry> getAllEntries() {
        return this.entries.stream().flatMap(entry -> entry.allChildren());
    }

    public ProjectComparisonEntry getEntryForObject(Object object) {
        return this.objToEntry.get(object);
    }

    public void clearAllCachedCompareResults() {
        this.getAllEntries().forEach(entry -> entry.clearCachedCompareResults());
    }
}

