/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.jsdoc.N4JSDocHelper;
import org.eclipse.n4js.jsdoc.N4JSDocletParser;
import org.eclipse.n4js.jsdoc.dom.Doclet;
import org.eclipse.n4js.jsdoc.dom.FullMemberReference;
import org.eclipse.n4js.jsdoc.dom.LineTag;
import org.eclipse.n4js.jsdoc2spec.IJSDoc2SpecIssueAcceptor;
import org.eclipse.n4js.jsdoc2spec.RepoRelativePath;
import org.eclipse.n4js.jsdoc2spec.SpecInfo;
import org.eclipse.n4js.jsdoc2spec.SpecInfosByName;
import org.eclipse.n4js.jsdoc2spec.SubMonitorMsg;
import org.eclipse.n4js.jsdoc2spec.adoc.RepoRelativePathHolder;
import org.eclipse.n4js.n4JS.FunctionOrFieldAccessor;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.scoping.N4JSGlobalScopeProvider;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.SyntaxRelatedTElement;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TVariable;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.util.MemberList;
import org.eclipse.n4js.utils.ContainerTypesHelper;
import org.eclipse.xtext.EcoreUtil2;

public class N4JSDReader {
    @Inject
    ContainerTypesHelper containerTypesHelper;
    @Inject
    N4JSDocHelper n4jsDocHelper;
    @Inject
    IN4JSCore n4jsCore;
    @Inject
    N4JSGlobalScopeProvider globalScopeProvider;
    @Inject
    RepoRelativePathHolder rrph;
    IJSDoc2SpecIssueAcceptor issueAcceptor = IJSDoc2SpecIssueAcceptor.NULL_ACCEPTOR;

    public Collection<SpecInfo> readN4JSDs(Collection<IN4JSProject> projects, Function<IN4JSProject, ResourceSet> resSetProvider, SubMonitorMsg monitor) throws InterruptedException {
        SpecInfosByName specInfosByName = new SpecInfosByName(this.issueAcceptor, this.globalScopeProvider, this.containerTypesHelper, this.n4jsCore);
        ResourceSet resSet = null;
        SubMonitorMsg sub = monitor.convert(200 * projects.size());
        for (IN4JSProject project : projects) {
            if (resSet == null) {
                resSet = resSetProvider.apply(project);
            }
            this.readScripts(specInfosByName, project, resSet, sub.newChild(100));
        }
        for (IN4JSProject project : projects) {
            if (resSet == null) {
                resSet = resSetProvider.apply(project);
            }
            this.linkTests(specInfosByName, project, resSet, sub.newChild(100));
        }
        return specInfosByName.values();
    }

    private void readScripts(SpecInfosByName specInfosByName, IN4JSProject project, ResourceSet resSet, SubMonitorMsg monitor) throws InterruptedException {
        ImmutableList srcCont = project.getSourceContainers();
        LinkedList<IN4JSSourceContainer> srcContFilter = new LinkedList<IN4JSSourceContainer>();
        int count = 0;
        for (IN4JSSourceContainer container : srcCont) {
            if (!container.isSource() && !container.isTest()) continue;
            count += Iterables.size((Iterable)container);
            srcContFilter.add(container);
        }
        SubMonitorMsg sub = monitor.convert(count);
        for (IN4JSSourceContainer container : srcContFilter) {
            for (URI uri : container) {
                String ext = uri.fileExtension();
                if ("n4js".equals(ext) || "n4jsd".equals(ext)) {
                    try {
                        Resource resource = resSet.getResource(uri, true);
                        if (resource != null) {
                            Script script = (Script)(resource.getContents().isEmpty() ? null : (EObject)resource.getContents().get(0));
                            if (script == null) continue;
                            N4JSResource.postProcess((Resource)resource);
                            for (Type type : this.getRealTopLevelTypes(script)) {
                                specInfosByName.createTypeSpecInfo(type, this.rrph);
                            }
                            for (TVariable tvar : script.getModule().getVariables()) {
                                specInfosByName.createTVarSpecInfo(tvar, this.rrph);
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        String msg = "Error processing " + uri + ": " + ex.getMessage();
                        throw new IllegalArgumentException(msg, ex);
                    }
                }
                sub.worked(1);
                sub.checkCanceled();
            }
        }
    }

    private Collection<Type> getRealTopLevelTypes(Script script) {
        LinkedList<Type> realTLT = new LinkedList<Type>();
        for (Type tlt : script.getModule().getTopLevelTypes()) {
            SyntaxRelatedTElement srte;
            EObject astElem;
            FunctionOrFieldAccessor fofa;
            if (tlt instanceof SyntaxRelatedTElement && (fofa = (FunctionOrFieldAccessor)EcoreUtil2.getContainerOfType((EObject)(astElem = (astElem = (srte = (SyntaxRelatedTElement)tlt).getAstElement()) != null ? astElem.eContainer() : null), FunctionOrFieldAccessor.class)) != null) continue;
            realTLT.add(tlt);
        }
        return realTLT;
    }

    private void linkTests(SpecInfosByName specInfosByName, IN4JSProject project, ResourceSet resSet, SubMonitorMsg monitor) throws InterruptedException {
        List<Type> testTypes = this.getTestTypes(project, resSet, monitor);
        for (Type testType : testTypes) {
            try {
                if (!(testType instanceof TClassifier)) continue;
                TClassifier ctype = (TClassifier)testType;
                this.processClassifier(specInfosByName, ctype);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                String msg = "Error processing " + testType.eResource().getURI().toString() + ": " + ex.getMessage();
                throw new IllegalArgumentException(msg);
            }
        }
    }

    private List<Type> getTestTypes(IN4JSProject project, ResourceSet resSet, SubMonitorMsg monitor) throws InterruptedException {
        ArrayList<Type> testTypes = new ArrayList<Type>();
        ImmutableList srcCont = project.getSourceContainers();
        int count = 0;
        for (IN4JSSourceContainer container : srcCont) {
            if (!container.isTest()) continue;
            count += Iterables.size((Iterable)container);
        }
        SubMonitorMsg sub = monitor.convert(count);
        for (IN4JSSourceContainer container : srcCont) {
            if (!container.isTest()) continue;
            for (URI uri : container) {
                Resource resource;
                String ext = uri.fileExtension();
                if ("n4js".equals(ext) && (resource = resSet.getResource(uri, true)) != null) {
                    Script script = (Script)(resource.getContents().isEmpty() ? null : (EObject)resource.getContents().get(0));
                    if (script == null) {
                        throw new IllegalStateException("Error parsing " + uri);
                    }
                    N4JSResource.postProcess((Resource)resource);
                    for (Type type : this.getRealTopLevelTypes(script)) {
                        testTypes.add(type);
                    }
                }
                sub.worked(1);
                sub.checkCanceled();
            }
        }
        return testTypes;
    }

    private void processClassifier(SpecInfosByName specInfosByName, TClassifier testType) {
        RepoRelativePath rrpOfTest = RepoRelativePath.compute(this.createFileURI((EObject)testType), this.n4jsCore);
        Doclet testTypeDoclet = this.n4jsDocHelper.getDoclet(testType.getAstElement());
        Collection<FullMemberReference> testeeRefsFromType = this.getFullMemberRefsFromType(testTypeDoclet);
        Collection<FullMemberReference> testeeTypeRefsFromType = this.getFullTypeRefsFromType(testTypeDoclet);
        MemberList allMembers = this.containerTypesHelper.fromContext((EObject)testType).allMembers((ContainerType)testType, false, false);
        for (TMember testMember : allMembers) {
            boolean isOwnedMember;
            boolean bl = isOwnedMember = testMember.getContainingType() == testType;
            if (!(testMember instanceof TMethod) || !AnnotationDefinition.TEST_METHOD.hasAnnotation((TAnnotableElement)testMember)) continue;
            EObject astElement = testMember.getAstElement();
            if (!astElement.eIsProxy()) {
                Doclet testMethodDoclet = this.n4jsDocHelper.getDoclet(astElement);
                LineTag tag = this.findLinkToElementTag(testMethodDoclet, isOwnedMember);
                if (tag == null) continue;
                this.processTag(specInfosByName, rrpOfTest, testeeRefsFromType, testeeTypeRefsFromType, testMember, isOwnedMember, astElement, testMethodDoclet, tag);
                continue;
            }
            System.err.println("cannot result AST when scanning for doclets: " + astElement);
        }
    }

    private void processTag(SpecInfosByName specInfosByName, RepoRelativePath rrpOfTest, Collection<FullMemberReference> testeeRefsFromType, Collection<FullMemberReference> testeeTypeRefsFromType, TMember testMember, boolean isOwnedMember, EObject astElement, Doclet testMethodDoclet, LineTag tag) {
        String title = tag.getTitle().getTitle();
        if ("testee".equals(title)) {
            FullMemberReference ref = this.getFullMemberRef(tag);
            if (ref != null) {
                specInfosByName.addTestInfoForCodeElement(rrpOfTest, testMethodDoclet, ref, testMember);
            }
        } else if ("testeeFromType".equals(title)) {
            RepoRelativePath rrpTestMethod = isOwnedMember ? rrpOfTest : RepoRelativePath.compute(this.createFileURI(astElement), this.n4jsCore);
            for (FullMemberReference ref : testeeRefsFromType) {
                specInfosByName.addTestInfoForCodeElement(rrpTestMethod, testMethodDoclet, ref, testMember);
            }
        } else if ("testeeMember".equals(title)) {
            String testeeMember = N4JSDocletParser.TAG_TESTEEMEMBER.getValue(tag, "");
            RepoRelativePath rrpTestMethod = isOwnedMember ? rrpOfTest : RepoRelativePath.compute(this.createFileURI(astElement), this.n4jsCore);
            for (FullMemberReference testeeTypeRef : testeeTypeRefsFromType) {
                FullMemberReference combinedTesteeRef = (FullMemberReference)EcoreUtil.copy((EObject)testeeTypeRef);
                combinedTesteeRef.setMemberName(testeeMember);
                combinedTesteeRef.setRange(tag.getBegin(), tag.getEnd());
                specInfosByName.addTestInfoForCodeElement(rrpTestMethod, testMethodDoclet, combinedTesteeRef, testMember);
            }
        } else if ("reqid".equals(title)) {
            String reqid = N4JSDocletParser.TAG_REQID.getValue(tag, "");
            if (Strings.isNullOrEmpty((String)reqid)) {
                throw new IllegalStateException("Found reqid tag without requirement ID.");
            }
            RepoRelativePath rrpTestMethod = isOwnedMember ? rrpOfTest : RepoRelativePath.compute(this.createFileURI(astElement), this.n4jsCore);
            specInfosByName.addTestInfoForRequirement(rrpTestMethod, testMethodDoclet, reqid, testMember);
        } else {
            System.err.println("unhandled referencing tag: " + title);
        }
    }

    private LineTag findLinkToElementTag(Doclet testMethodDoclet, boolean isOwnedMember) {
        LineTag bestMatch = null;
        for (LineTag tag : testMethodDoclet.getLineTags()) {
            if (isOwnedMember && "testee".equals(tag.getTitle().getTitle())) {
                bestMatch = tag;
                break;
            }
            if ("testeeFromType".equals(tag.getTitle().getTitle())) {
                bestMatch = tag;
                continue;
            }
            if ("testeeMember".equals(tag.getTitle().getTitle())) {
                if (bestMatch != null && !"reqid".equals(bestMatch.getTitle().getTitle())) continue;
                bestMatch = tag;
                continue;
            }
            if (!isOwnedMember || !"reqid".equals(tag.getTitle().getTitle()) || bestMatch != null) continue;
            bestMatch = tag;
        }
        return bestMatch;
    }

    private Collection<FullMemberReference> getFullMemberRefsFromType(Doclet testTypeDoclet) {
        HashMap<String, FullMemberReference> refsByName = new HashMap<String, FullMemberReference>();
        for (LineTag tag : testTypeDoclet.getLineTags()) {
            FullMemberReference ref;
            if (!"testee".equals(tag.getTitle().getTitle()) || (ref = this.getFullMemberRef(tag)) == null) continue;
            refsByName.put(ref.toString(), ref);
        }
        return refsByName.values();
    }

    private Collection<FullMemberReference> getFullTypeRefsFromType(Doclet testTypeDoclet) {
        HashMap<String, FullMemberReference> refsByName = new HashMap<String, FullMemberReference>();
        for (LineTag tag : testTypeDoclet.getLineTags()) {
            FullMemberReference ref;
            if (!"testeeType".equals(tag.getTitle().getTitle()) || (ref = this.getFullMemberRef(tag)) == null) continue;
            refsByName.put(ref.toString(), ref);
        }
        return refsByName.values();
    }

    private FullMemberReference getFullMemberRef(LineTag tag) {
        EList contents = tag.getValueByKey("REF").getContents();
        if (!contents.isEmpty()) {
            return (FullMemberReference)contents.get(0);
        }
        return null;
    }

    private FileURI createFileURI(EObject eObject) {
        return new FileURI(eObject.eResource().getURI());
    }
}

