/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.project;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.Injector;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.n4js.json.JSON.JSONPackage;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.resource.packagejson.PackageJsonResourceDescriptionExtension;
import org.eclipse.n4js.ui.internal.N4JSActivator;
import org.eclipse.n4js.ui.wizard.project.N4JSProjectInfo;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ExtensibleWizardNewProjectCreationPage;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;

public class N4JSNewProjectWizardCreationPage
extends ExtensibleWizardNewProjectCreationPage {
    private final N4JSProjectInfo projectInfo;
    private static final Pattern VENDOR_ID_PATTERN = Pattern.compile("\\^?[A-Za-z\\_][A-Za-z_\\-\\.0-9]*");

    public N4JSNewProjectWizardCreationPage(N4JSProjectInfo projectInfo) {
        super(N4JSNewProjectWizardCreationPage.class.getName());
        this.projectInfo = projectInfo;
        this.setTitle("N4JS Project");
        this.setDescription("Create a new N4JS project.");
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete() && ProjectType.TEST.equals((Object)this.projectInfo.getProjectType());
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite control = (Composite)this.getControl();
        control.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        control.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 4).grab(true, true).create());
        DataBindingContext dbc = new DataBindingContext();
        control.addDisposeListener(e -> dbc.dispose());
        this.createVendorIdControls(dbc, control);
        ComboViewer projectTypeCombo = new ComboViewer(control, 8);
        projectTypeCombo.setLabelProvider((IBaseLabelProvider)new ProjectTypeLabelProvider());
        projectTypeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        projectTypeCombo.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        projectTypeCombo.setInput((Object)ProjectType.values());
        Composite projectTypePropertyControls = new Composite(control, 0);
        StackLayout changingStackLayout = new StackLayout();
        projectTypePropertyControls.setLayout((Layout)changingStackLayout);
        projectTypePropertyControls.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 4).grab(true, true).create());
        Composite defaultOptions = this.initDefaultOptionsUI(dbc, projectTypePropertyControls);
        Composite libraryProjectOptionsGroup = this.initLibraryOptionsUI(dbc, projectTypePropertyControls);
        Composite testProjectOptionsGroup = this.initTestProjectUI(dbc, projectTypePropertyControls);
        this.initProjectTypeBinding(dbc, projectTypeCombo);
        projectTypeCombo.addPostSelectionChangedListener(e -> {
            switch (this.projectInfo.getProjectType()) {
                case LIBRARY: {
                    stackLayout.topControl = libraryProjectOptionsGroup;
                    break;
                }
                case TEST: {
                    stackLayout.topControl = testProjectOptionsGroup;
                    break;
                }
                default: {
                    stackLayout.topControl = defaultOptions;
                }
            }
            projectTypePropertyControls.layout(true);
            this.setPageComplete(this.validatePage());
        });
        this.createWorkingSetGroup((Composite)this.getControl(), null, new String[]{"org.eclipse.ui.resourceWorkingSetPage", "org.eclipse.jdt.ui.JavaWorkingSetPage", "org.eclipse.jdt.internal.ui.OthersWorkingSet"});
        Dialog.applyDialogFont((Control)this.getControl());
        dbc.updateTargets();
        this.setControl((Control)control);
    }

    @Override
    public String getProjectName() {
        return ProjectDescriptionUtils.getPlainProjectName((String)super.getProjectName());
    }

    @Override
    public IProject getProjectHandle() {
        String eclipseProjectName = ProjectDescriptionUtils.convertN4JSProjectNameToEclipseProjectName((String)this.getProjectName());
        return ResourcesPlugin.getWorkspace().getRoot().getProject(eclipseProjectName);
    }

    protected String getProjectNameWithScope() {
        return super.getProjectName();
    }

    @Override
    protected void setLocationForSelection() {
        this.locationArea.updateProjectName(this.getProjectNameWithScope());
    }

    private void createVendorIdControls(DataBindingContext dbc, Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        composite.setLayoutData((Object)new GridData(768));
        Label vendorIdLabel = new Label(composite, 0);
        vendorIdLabel.setText("Vendor id:");
        Text vendorIdText = new Text(composite, 2048);
        vendorIdText.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 4).grab(true, true).create());
        this.projectInfo.addPropertyChangeListener(event -> {
            if (event.getPropertyName().equals("vendorId")) {
                this.setPageComplete(this.validatePage());
            }
        });
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)vendorIdText), BeanProperties.value(N4JSProjectInfo.class, (String)"vendorId").observe((Object)this.projectInfo));
    }

    private Composite initDefaultOptionsUI(DataBindingContext dbc, Composite parent) {
        Group defaultOptions = new Group(parent, 0);
        defaultOptions.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(1).create());
        Button createGreeterFileButton = new Button((Composite)defaultOptions, 32);
        createGreeterFileButton.setText("Create a greeter file");
        this.initDefaultCreateGreeterBindings(dbc, createGreeterFileButton);
        return defaultOptions;
    }

    private Composite initLibraryOptionsUI(DataBindingContext dbc, Composite parent) {
        Group libraryProjectOptionsGroup = new Group(parent, 0);
        libraryProjectOptionsGroup.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(12, 5).numColumns(2).equalWidth(false).create());
        N4JSNewProjectWizardCreationPage.emptyPlaceholder((Composite)libraryProjectOptionsGroup);
        Button createGreeterFileButton = new Button((Composite)libraryProjectOptionsGroup, 32);
        createGreeterFileButton.setText("Create a greeter file");
        createGreeterFileButton.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        new Label((Composite)libraryProjectOptionsGroup, 0).setText("Implementation ID:");
        Text implementationIdText = new Text((Composite)libraryProjectOptionsGroup, 2048);
        implementationIdText.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
        Label implementedProjectsLabel = new Label((Composite)libraryProjectOptionsGroup, 0);
        implementedProjectsLabel.setText("Implemented projects:");
        implementedProjectsLabel.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).align(16384, 128).create());
        ListViewer apiViewer = new ListViewer((Composite)libraryProjectOptionsGroup, 2050);
        apiViewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(1, 1).create());
        apiViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        apiViewer.setInput(this.getAvailableApiProjectNames());
        this.initApiViewerBinding(dbc, apiViewer);
        this.initImplementationIdBinding(dbc, implementationIdText);
        this.initDefaultCreateGreeterBindings(dbc, createGreeterFileButton);
        apiViewer.addSelectionChangedListener(e -> this.setPageComplete(this.validatePage()));
        implementationIdText.addModifyListener(e -> this.setPageComplete(this.validatePage()));
        return libraryProjectOptionsGroup;
    }

    private static Control emptyPlaceholder(Composite parent) {
        return new Label(parent, 0);
    }

    private Composite initTestProjectUI(DataBindingContext dbc, Composite parent) {
        Group testProjectOptionsGroup = new Group(parent, 0);
        testProjectOptionsGroup.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(1).create());
        Button createTestGreeterFileButton = new Button((Composite)testProjectOptionsGroup, 32);
        createTestGreeterFileButton.setText("Create a test project greeter file");
        Button addNormalSourceFolderButton = new Button((Composite)testProjectOptionsGroup, 32);
        addNormalSourceFolderButton.setText("Also create a non-test source folder");
        Label nextPageHint = new Label((Composite)testProjectOptionsGroup, 0);
        nextPageHint.setText("The projects which should be tested can be selected on the next page");
        nextPageHint.setForeground(Display.getCurrent().getSystemColor(33));
        this.initTestProjectBinding(dbc, addNormalSourceFolderButton, createTestGreeterFileButton);
        return testProjectOptionsGroup;
    }

    @Override
    protected boolean validatePage() {
        boolean valid;
        boolean bl = valid = this.validateProjectNameNonEmpty() && super.validatePage() && this.validateIsExistingProjectPath() && this.validateProjectName() && this.validateVendorId() && this.validateImplementationId();
        if (valid) {
            this.setErrorMessage(null);
            this.updateModel();
        }
        return valid;
    }

    private boolean validateProjectNameNonEmpty() {
        String fullProjectName = this.getProjectNameWithScope();
        String scopeName = ProjectDescriptionUtils.getScopeName((String)fullProjectName);
        String plainProjectName = ProjectDescriptionUtils.getPlainProjectName((String)fullProjectName);
        if (fullProjectName.isEmpty()) {
            this.setErrorMessage(null);
            this.setMessage("Project name must be specified");
            return false;
        }
        if (scopeName != null && (scopeName.isEmpty() || scopeName.equals("@"))) {
            this.setErrorMessage("The scope segment of the project name must not be empty.");
            return false;
        }
        if (plainProjectName != null && plainProjectName.isEmpty()) {
            this.setErrorMessage("The name segment of the project name must not be empty.");
            return false;
        }
        return true;
    }

    private boolean validateProjectName() {
        String projectName = this.getProjectNameWithScope();
        String plainProjectName = this.getProjectName();
        String scopeName = ProjectDescriptionUtils.getScopeName((String)projectName);
        if (scopeName != null && !ProjectDescriptionUtils.isValidScopeName((String)scopeName)) {
            this.setErrorMessage("Invalid project name: \"" + scopeName + "\" is not a valid scope segment.");
            return false;
        }
        if (!ProjectDescriptionUtils.isValidPlainProjectName((String)plainProjectName)) {
            this.setErrorMessage("Invalid project name: \"" + plainProjectName + "\" is not a valid name segment.");
            return false;
        }
        if (CharMatcher.breakingWhitespace().matchesAnyOf((CharSequence)projectName)) {
            this.setErrorMessage("Project name should not contain any whitespace characters.");
            return false;
        }
        if (Strings.isNullOrEmpty((String)projectName)) {
            this.setErrorMessage("Project name should be specified.");
            return false;
        }
        return true;
    }

    private boolean validateVendorId() {
        String vendorId = this.projectInfo.getVendorId();
        if (Strings.isNullOrEmpty((String)vendorId)) {
            this.setErrorMessage("Vendor id must not be empty.");
            return false;
        }
        if (!VENDOR_ID_PATTERN.matcher(vendorId).matches()) {
            this.setErrorMessage("Invalid vendor id.");
            return false;
        }
        return true;
    }

    private boolean validateImplementationId() {
        String implementationId;
        if (ProjectType.LIBRARY.equals((Object)this.projectInfo.getProjectType()) && !Strings.isNullOrEmpty((String)(implementationId = this.projectInfo.getImplementationId()))) {
            char leadingChar = implementationId.charAt(0);
            if (CharMatcher.is((char)'_').or(CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z'))).matches(leadingChar)) {
                this.setErrorMessage("Implementation ID should start either an upper or a lower case character from the Latin alphabet or with the underscore character.");
                return false;
            }
            List<String> implementedApis = this.projectInfo.getImplementedProjects();
            if (implementedApis == null || implementedApis.isEmpty()) {
                this.setErrorMessage("One or more API project should be selected for implementation when the implementation ID is specified.");
                return false;
            }
            if (CharMatcher.breakingWhitespace().matchesAnyOf((CharSequence)implementationId)) {
                this.setErrorMessage("Implementation ID should not contain any whitespace characters.");
                return false;
            }
        }
        return true;
    }

    public void updateSelectedWorkingSets() {
        this.projectInfo.setSelectedWorkingSets(this.getSelectedWorkingSets());
    }

    private void updateModel() {
        boolean isScoped;
        String eclipseProjectName = ProjectDescriptionUtils.convertN4JSProjectNameToEclipseProjectName((String)this.getProjectNameWithScope());
        this.projectInfo.setProjectName(eclipseProjectName);
        boolean bl = isScoped = this.getProjectNameWithScope() != this.getProjectName();
        if (this.useDefaults() && isScoped) {
            this.projectInfo.setProjectLocation(this.getLocationPath().append(this.getProjectNameWithScope()));
        } else if (this.useDefaults()) {
            this.projectInfo.setProjectLocation(null);
        } else {
            this.projectInfo.setProjectLocation(this.getLocationPath());
        }
    }

    private void initDefaultCreateGreeterBindings(DataBindingContext dbc, Button createGreeterFileButton) {
        dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)createGreeterFileButton), BeanProperties.value(N4JSProjectInfo.class, (String)"createGreeterFile").observe((Object)this.projectInfo));
    }

    private void initTestProjectBinding(DataBindingContext dbc, Button addNormalSourceFolderButton, Button createTestGreeterFileButton) {
        dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)addNormalSourceFolderButton), PojoProperties.value(N4JSProjectInfo.class, (String)"additionalSourceFolder").observe((Object)this.projectInfo));
        dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)createTestGreeterFileButton), BeanProperties.value(N4JSProjectInfo.class, (String)"createGreeterFile").observe((Object)this.projectInfo));
    }

    private void initProjectTypeBinding(DataBindingContext dbc, ComboViewer projectType) {
        dbc.bindValue((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)projectType), PojoProperties.value(N4JSProjectInfo.class, (String)"projectType").observe((Object)this.projectInfo));
    }

    private void initImplementationIdBinding(DataBindingContext dbc, Text text) {
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)text), PojoProperties.value(N4JSProjectInfo.class, (String)"implementationId").observe((Object)this.projectInfo));
    }

    private void initApiViewerBinding(DataBindingContext dbc, ListViewer apiViewer) {
        dbc.bindList((IObservableList)ViewerProperties.multipleSelection().observe((Viewer)apiViewer), PojoProperties.list(N4JSProjectInfo.class, (String)"implementedProjects").observe((Object)this.projectInfo));
    }

    private boolean validateIsExistingProjectPath() {
        boolean isExistingNonWorkspaceProject;
        IPath projectLocation = this.getLocationPath();
        String projectName = this.getProjectName();
        if (projectLocation.equals((Object)Platform.getLocation())) {
            projectLocation = projectLocation.append(projectName);
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        boolean workspaceProjectExists = root.getProject(projectName).exists();
        IPath projectDescriptionPath = projectLocation.append("package.json");
        File existingProjectDescriptionFile = new File(projectDescriptionPath.toString());
        File existingFileAtProjectDirectory = new File(projectLocation.toString());
        boolean projectDirectoryIsExistingFile = existingFileAtProjectDirectory.isFile();
        boolean bl = isExistingNonWorkspaceProject = existingProjectDescriptionFile.exists() && !workspaceProjectExists;
        if (projectDirectoryIsExistingFile) {
            this.setErrorMessage("There already exists a file at the location '" + projectLocation.toString() + "'.");
            return false;
        }
        if (isExistingNonWorkspaceProject) {
            this.setErrorMessage("There already exists an N4JS project at the specified location. Please use 'File > Import...' to add it to the workspace.");
            return false;
        }
        return true;
    }

    private Collection<String> getAvailableApiProjectNames() {
        ImmutableSet distinctIds = FluentIterable.from((Iterable)this.getResourceDescriptions().getExportedObjectsByType(JSONPackage.Literals.JSON_DOCUMENT)).filter(desc -> ProjectType.API.equals((Object)PackageJsonResourceDescriptionExtension.getProjectType((IEObjectDescription)desc))).transform(desc -> PackageJsonResourceDescriptionExtension.getProjectName((IEObjectDescription)desc)).filter(id -> id != null).toSet();
        ArrayList ids = Lists.newArrayList((Iterable)distinctIds);
        Collections.sort(ids);
        return ids;
    }

    private IResourceDescriptions getResourceDescriptions() {
        return (IResourceDescriptions)this.getInjector().getInstance(IResourceDescriptions.class);
    }

    private Injector getInjector() {
        return N4JSActivator.getInstance().getInjector("org.eclipse.n4js.N4JS");
    }

    private static final class ProjectTypeLabelProvider
    extends LabelProvider {
        private ProjectTypeLabelProvider() {
        }

        public String getText(Object element) {
            if (ProjectType.API.equals(element)) {
                return ProjectType.API.getLiteral();
            }
            return this.getDefaultText(element);
        }

        private String getDefaultText(Object element) {
            return org.eclipse.xtext.util.Strings.toFirstUpper((String)Strings.nullToEmpty((String)super.getText(element)).replaceAll("_", " ").toLowerCase());
        }
    }
}

