/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xtext.scoping;

import com.google.common.collect.Iterables;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.xtext.scoping.IEObjectDescriptionWithError;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public abstract class FilterWithErrorMarkerScope
implements IScope {
    protected final IScope parent;

    public static boolean isDecoratedWithFilter(IScope scope, Class<? extends FilterWithErrorMarkerScope> filterScopeType) {
        if (filterScopeType.isInstance(scope)) {
            return true;
        }
        if (scope instanceof FilterWithErrorMarkerScope) {
            return FilterWithErrorMarkerScope.isDecoratedWithFilter(((FilterWithErrorMarkerScope)scope).parent, filterScopeType);
        }
        return false;
    }

    public FilterWithErrorMarkerScope(IScope parent) {
        this.parent = parent;
    }

    protected abstract IEObjectDescriptionWithError wrapFilteredDescription(IEObjectDescription var1);

    protected abstract boolean isAccepted(IEObjectDescription var1);

    protected boolean tryAcceptWithoutResolve(IEObjectDescription description) {
        return this.isAccepted(description);
    }

    public IEObjectDescription getSingleElement(QualifiedName name) {
        IEObjectDescription result = this.parent.getSingleElement(name);
        if (result == null || this.isAccepted(result)) {
            return result;
        }
        Iterable allElements = this.parent.getElements(name);
        for (IEObjectDescription description : allElements) {
            if (!this.isAccepted(description)) continue;
            return description;
        }
        return this.wrapFilteredDescription(result);
    }

    public IEObjectDescription getSingleElement(EObject object) {
        IEObjectDescription result = this.parent.getSingleElement(object);
        if (result == null || this.isAccepted(result)) {
            return result;
        }
        return this.wrapFilteredDescription(result);
    }

    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        return this.decorateWithErrorIfFiltered(this.parent.getElements(name));
    }

    public Iterable<IEObjectDescription> getElements(EObject object) {
        return this.decorateWithErrorIfFiltered(this.parent.getElements(object));
    }

    public Iterable<IEObjectDescription> getAllElements() {
        return this.decorateWithErrorIfFilteredWithoutResolve(this.parent.getAllElements());
    }

    protected Iterable<IEObjectDescription> decorateWithErrorIfFiltered(Iterable<IEObjectDescription> originalDescriptions) {
        return this.doDecorateWithErrorIfFiltered(originalDescriptions, this::isAccepted);
    }

    protected Iterable<IEObjectDescription> decorateWithErrorIfFilteredWithoutResolve(Iterable<IEObjectDescription> originalDescriptions) {
        return this.doDecorateWithErrorIfFiltered(originalDescriptions, this::tryAcceptWithoutResolve);
    }

    protected Iterable<IEObjectDescription> doDecorateWithErrorIfFiltered(Iterable<IEObjectDescription> originalDescriptions, Predicate<IEObjectDescription> predicate) {
        Iterable filteredResult = Iterables.transform(originalDescriptions, it -> {
            if (it == null || predicate.test((IEObjectDescription)it)) {
                return it;
            }
            return this.wrapFilteredDescription((IEObjectDescription)it);
        });
        return Iterables.filter((Iterable)filteredResult, it -> it != null);
    }

    public String toString() {
        return IterableExtensions.join(this.getAllElements(), (CharSequence)", ");
    }
}

