/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.helper;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.junit.Assert;

public class SystemOutRedirecter {
    private PrintStream oldSystemOut;
    private PrintStream oldSystemErr;
    private ByteArrayOutputStream redirectOut;
    private ByteArrayOutputStream redirectErr;

    public final void set(boolean mirrorOnSystemOut) {
        this.oldSystemOut = System.out;
        this.oldSystemErr = System.err;
        this.redirectOut = new ByteArrayOutputStream();
        this.redirectErr = new ByteArrayOutputStream();
        PrintStream mirrorOut = mirrorOnSystemOut ? this.oldSystemOut : null;
        PrintStream mirrorErr = mirrorOnSystemOut ? this.oldSystemErr : null;
        try {
            DualStream psOut = new DualStream(this.redirectOut, true, "UTF-8", mirrorOut);
            DualStream psErr = new DualStream(this.redirectErr, true, "UTF-8", mirrorErr);
            System.setOut(psOut);
            System.setErr(psErr);
        }
        catch (UnsupportedEncodingException e) {
            Assert.fail((String)"Could not redirect output streams");
        }
    }

    public final void unset() {
        System.out.flush();
        System.err.flush();
        System.out.close();
        System.err.close();
        System.setOut(this.oldSystemOut);
        System.setErr(this.oldSystemErr);
    }

    public String getSystemOut() {
        try {
            System.out.flush();
            String output = this.redirectOut == null ? "" : this.redirectOut.toString("UTF-8");
            return output;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getSystemErr() {
        try {
            System.err.flush();
            String output = this.redirectErr == null ? "" : this.redirectErr.toString("UTF-8");
            return output;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    static class DualStream
    extends PrintStream {
        private final PrintStream out2;

        public DualStream(OutputStream out, boolean autoFlush, String encoding, PrintStream out2) throws UnsupportedEncodingException {
            super(out, autoFlush, encoding);
            this.out2 = out2;
        }

        @Override
        public void println(String x) {
            super.println(x);
            if (this.out2 != null) {
                this.out2.println(x);
            }
        }

        @Override
        public void print(String x) {
            super.print(x);
            if (this.out2 != null) {
                this.out2.print(x);
            }
        }
    }
}

