/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.filechecker;

import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.function.Function;
import org.eclipse.n4js.filechecker.Report;

public class ReportUtils {
    public static Collection<Report> filterIgnoredReports(Collection<Report> reports) {
        return ReportUtils.filterReports(reports, Report::isIgnored);
    }

    public static Collection<Report> filterNotIgnoredReports(Collection<Report> reports) {
        return ReportUtils.filterReports(reports, Report::isNotIgnored);
    }

    public static Collection<Report> filterValidReports(Collection<Report> reports) {
        return ReportUtils.filterReports(reports, Report::isValid);
    }

    public static Collection<Report> filterInvalidReports(Collection<Report> reports) {
        return ReportUtils.filterReports(reports, Report::isInvalid);
    }

    public static Collection<Report> filterErroneousReports(Collection<Report> reports) {
        return ReportUtils.filterReports(reports, Report::isErroneous);
    }

    public static Collection<Report> filterReportsNoCRH(Collection<Report> reports) {
        return ReportUtils.filterReports(reports, Report::isMissingCopyrightHeader);
    }

    public static Collection<Report> filterReportsInTests(Collection<Report> reports) {
        return ReportUtils.filterReports(reports, Report::isInTestProject);
    }

    public static Collection<Report> filterReportsInN4JS(Collection<Report> reports) {
        return ReportUtils.filterReports(reports, Report::isInN4JSRepo);
    }

    public static Collection<Report> filterReportsInN4JSExtended(Collection<Report> reports) {
        return ReportUtils.filterReports(reports, Report::isInN4JSExtendedRepo);
    }

    public static Collection<Report> filterReportsNotInTests(Collection<Report> reports) {
        return ReportUtils.filterReports(reports, Report::isNotInTestProject);
    }

    public static Collection<Report> filterReports(Collection<Report> reports, Function<Report, Boolean> filter) {
        LinkedList<Report> filteredReports = new LinkedList<Report>();
        for (Report report : reports) {
            if (!filter.apply(report).booleanValue()) continue;
            filteredReports.add(report);
        }
        return filteredReports;
    }

    public static <E extends Comparable<E>, T extends Comparable<T>> Multimap<T, E> getHistogram(Collection<E> elems, Function<E, T> pivot) {
        TreeMultimap histogram = TreeMultimap.create();
        for (Comparable elem : elems) {
            Comparable t = (Comparable)pivot.apply(elem);
            histogram.put((Object)t, (Object)elem);
        }
        return histogram;
    }

    public static <E extends Comparable<E>, T extends Comparable<T>> TreeMap<T, Collection<E>> sortByListSize(final Multimap<T, E> multimap) {
        Comparator comparator = new Comparator<T>(){

            @Override
            public int compare(T t1, T t2) {
                int s1 = multimap.get(t1).size();
                int s2 = multimap.get(t2).size();
                if (s2 != s1) {
                    return s2 - s1;
                }
                return t1.compareTo(t2);
            }
        };
        TreeMap<Comparable, Collection> sortedMap = new TreeMap<Comparable, Collection>(comparator);
        for (Comparable key : multimap.keySet()) {
            Collection elems = multimap.get((Object)key);
            sortedMap.put(key, elems);
        }
        return sortedMap;
    }
}

