/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.state;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.lang.annotation.Annotation;
import java.util.List;
import org.eclipse.xpect.state.Default;
import org.eclipse.xpect.state.Managed;
import org.eclipse.xpect.state.ManagedImpl;
import org.eclipse.xpect.state.XpectStateAnnotation;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

public class Configuration {
    private final List<Class<?>> factories = Lists.newArrayList();
    private final String name;
    private final Multimap<Class<? extends Annotation>, Pair<Class<?>, Managed<?>>> values = LinkedHashMultimap.create();

    public Configuration(String name) {
        this.name = name;
    }

    public <T> void addDefaultValue(Class<? super T> type, Managed<T> value) {
        this.addValue((Class<? extends Annotation>)Default.class, type, (T)value);
    }

    public <T> void addDefaultValue(Class<? super T> type, T value) {
        this.addValue(Default.class, type, value);
    }

    public <T> void addDefaultValue(T value) {
        if (value instanceof Managed) {
            throw new IllegalStateException("please use addDefaultValue(Class<? super T> type, Managed<T> value)");
        }
        this.addValue(Default.class, value.getClass(), value);
    }

    public void addFactory(Class<?> factory) {
        Preconditions.checkNotNull(factory);
        this.factories.add(factory);
    }

    public <T> void addValue(Class<? extends Annotation> annotation, Class<? super T> type, Managed<T> value) {
        if (annotation.getAnnotation(XpectStateAnnotation.class) == null) {
            throw new IllegalStateException("@" + annotation.getName() + " must be annotated with @" + XpectStateAnnotation.class.getSimpleName());
        }
        this.values.put(annotation, (Object)Tuples.create(type, value));
    }

    public <T> void addValue(Class<? extends Annotation> annotation, Class<? super T> type, T value) {
        this.addValue(annotation, type, (T)new ManagedImpl<T>(value));
    }

    public <T> void addValue(Class<? extends Annotation> annotation, T value) {
        if (value instanceof Managed) {
            throw new IllegalStateException("please use addValue(Class<? extends Annotation> annotation, Class<? super T> type, Managed<T> value)");
        }
        this.addValue(annotation, value.getClass(), value);
    }

    public List<Class<?>> getFactories() {
        return this.factories;
    }

    public String getName() {
        return this.name;
    }

    public Multimap<Class<? extends Annotation>, Pair<Class<?>, Managed<?>>> getValues() {
        return this.values;
    }
}

