/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration.AbstractToStringGenerator;

public class StringConcatenationGenerator
extends AbstractToStringGenerator {
    private SumExpressionBuilder toStringExpressionBuilder;

    @Override
    protected void initialize() {
        super.initialize();
        this.toStringExpressionBuilder = new SumExpressionBuilder(null);
    }

    @Override
    protected void complete() throws CoreException {
        super.complete();
        ReturnStatement returnStatement = this.fAst.newReturnStatement();
        returnStatement.setExpression(this.toStringExpressionBuilder.getExpression());
        this.toStringMethod.getBody().statements().add(returnStatement);
    }

    @Override
    protected void addElement(Object element) {
        this.addElement(element, this.toStringExpressionBuilder);
    }

    private void addElement(Object element, SumExpressionBuilder builder) {
        if (element instanceof String) {
            builder.addString((String)element);
        }
        if (element instanceof Expression) {
            Expression expr = (Expression)element;
            if (expr instanceof ConditionalExpression) {
                ParenthesizedExpression expr2 = this.fAst.newParenthesizedExpression();
                expr2.setExpression(expr);
                expr = expr2;
            }
            builder.addExpression(expr);
        }
    }

    @Override
    protected void addMember(Object member, boolean addSeparator) {
        boolean[] interfaces = this.implementsInterfaces(this.getMemberType(member).getErasure(), new String[]{"java.util.Collection", "java.util.Map"});
        if (this.getContext().isLimitItems() && this.getContext().isSkipNulls() && (interfaces[0] || interfaces[1] || this.getMemberType(member).isArray())) {
            this.addMemberCheckNull(member, addSeparator);
        } else {
            super.addMember(member, addSeparator);
        }
    }

    @Override
    protected void addMemberCheckNull(Object member, boolean addSeparator) {
        ConditionalExpression cExpression = this.fAst.newConditionalExpression();
        InfixExpression infExpression = this.fAst.newInfixExpression();
        infExpression.setLeftOperand(this.createMemberAccessExpression(member, true, true));
        infExpression.setRightOperand((Expression)this.fAst.newNullLiteral());
        infExpression.setOperator(InfixExpression.Operator.NOT_EQUALS);
        cExpression.setExpression((Expression)infExpression);
        SumExpressionBuilder builder = new SumExpressionBuilder(null);
        String[] arrayString = this.getContext().getTemplateParser().getBody();
        int i = 0;
        while (i < arrayString.length) {
            this.addElement(this.processElement(arrayString[i], member), builder);
            ++i;
        }
        if (addSeparator) {
            this.addElement(this.getContext().getTemplateParser().getSeparator(), builder);
        }
        cExpression.setThenExpression(builder.getExpression());
        StringLiteral literal = this.fAst.newStringLiteral();
        literal.setLiteralValue(this.getContext().isSkipNulls() ? "" : "null");
        cExpression.setElseExpression((Expression)literal);
        ParenthesizedExpression pExpression = this.fAst.newParenthesizedExpression();
        pExpression.setExpression((Expression)cExpression);
        this.toStringExpressionBuilder.addExpression((Expression)pExpression);
    }

    private Expression createSumExpression(Expression left, Expression right) {
        if (right == null) {
            return left;
        }
        if (left == null) {
            return right;
        }
        return this.createInfixExpression(left, InfixExpression.Operator.PLUS, right);
    }

    private class SumExpressionBuilder {
        private Expression expression;
        private StringBuffer buffer;

        public SumExpressionBuilder(Expression expression) {
            this.expression = expression;
            this.buffer = new StringBuffer();
        }

        public Expression getExpression() {
            this.flushBuffer();
            return this.expression;
        }

        private void flushBuffer() {
            if (this.buffer.length() > 0) {
                StringLiteral bufferedStringLiteral = StringConcatenationGenerator.this.fAst.newStringLiteral();
                bufferedStringLiteral.setLiteralValue(this.buffer.toString());
                this.buffer.setLength(0);
                this.expression = StringConcatenationGenerator.this.createSumExpression(this.expression, (Expression)bufferedStringLiteral);
            }
        }

        public void addString(String string) {
            this.buffer.append(string);
        }

        public void addExpression(Expression exp) {
            this.flushBuffer();
            this.expression = StringConcatenationGenerator.this.createSumExpression(this.expression, exp);
        }
    }
}

