/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.building;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Queue;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScopeAccess;
import org.eclipse.xtext.builder.resourceloader.AbstractResourceLoader;
import org.eclipse.xtext.builder.resourceloader.IResourceLoader;
import org.eclipse.xtext.builder.resourceloader.ParallelResourceLoader;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

class BuildScopeAwareParallelLoader
extends ParallelResourceLoader {
    private IResourceSetProvider resourceSetProvider;
    private final int nThreads;

    BuildScopeAwareParallelLoader(IResourceSetProvider resourceSetProvider, IResourceLoader.Sorter sorter, int nThreads, int queueSize) {
        super(resourceSetProvider, sorter, nThreads, queueSize);
        this.nThreads = nThreads;
    }

    public IResourceSetProvider getResourceSetProvider() {
        if (this.resourceSetProvider == null) {
            throw new IllegalStateException();
        }
        return this.resourceSetProvider;
    }

    private boolean shouldParallelize(Collection<URI> uris) {
        return uris.size() > this.nThreads * 3;
    }

    public IResourceLoader.LoadOperation create(final ResourceSet parent, final IProject project) {
        this.resourceSetProvider = new BuiltInTypesReferencingResourceSetProvider(parent, super.getResourceSetProvider());
        return new IResourceLoader.LoadOperation(){
            IResourceLoader.LoadOperation delegate;

            public IResourceLoader.LoadResult next() throws IResourceLoader.LoadOperationException {
                return this.delegate.next();
            }

            public void load(Collection<URI> uris) {
                if (this.delegate == null) {
                    this.delegate = BuildScopeAwareParallelLoader.this.shouldParallelize(uris) ? BuildScopeAwareParallelLoader.super.create(parent, project) : new AbstractResourceLoader.CheckedLoadOperation((AbstractResourceLoader)BuildScopeAwareParallelLoader.this, (IResourceLoader.LoadOperation)new SerialLoader(parent));
                }
                this.delegate.load(uris);
            }

            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            public Collection<URI> cancel() {
                try {
                    Collection collection = this.delegate.cancel();
                    return collection;
                }
                finally {
                    BuildScopeAwareParallelLoader.this.resourceSetProvider = null;
                }
            }
        };
    }

    private static final class BuiltInTypesReferencingResourceSetProvider
    implements IResourceSetProvider {
        private final ResourceSet parent;
        private final IResourceSetProvider delegate;

        BuiltInTypesReferencingResourceSetProvider(ResourceSet parent, IResourceSetProvider delegate) {
            this.parent = parent;
            this.delegate = delegate;
        }

        public ResourceSet get(IProject project) {
            ResourceSet result = this.delegate.get(project);
            BuiltInTypeScope typeScope = BuiltInTypeScope.get((ResourceSet)this.parent);
            BuiltInTypeScopeAccess.registerBuiltInTypeScope((BuiltInTypeScope)typeScope, (ResourceSet)result);
            return result;
        }
    }

    final class SerialLoader
    implements IResourceLoader.LoadOperation {
        private final Queue<URI> queue = new ArrayDeque<URI>();
        private final ResourceSet parent;

        public SerialLoader(ResourceSet parent) {
            this.parent = parent;
        }

        public IResourceLoader.LoadResult next() {
            URI uri = this.queue.poll();
            try {
                Resource resource = this.parent.getResource(uri, true);
                return new IResourceLoader.LoadResult(resource, uri);
            }
            catch (WrappedException e) {
                throw new IResourceLoader.LoadOperationException(uri, (Exception)e.getCause());
            }
        }

        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        public Collection<URI> cancel() {
            return this.queue;
        }

        public void load(Collection<URI> uris) {
            this.queue.addAll(BuildScopeAwareParallelLoader.this.getSorter().sort(uris));
        }
    }
}

