/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.internal.lsp;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.internal.lsp.N4JSProjectConfig;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IWorkspaceConfig;

public class N4JSWorkspaceConfig
implements IWorkspaceConfig {
    private final IN4JSCore delegate;

    public N4JSWorkspaceConfig(IN4JSCore delegate) {
        this.delegate = delegate;
    }

    public IProjectConfig findProjectByName(String name) {
        IN4JSProject project = (IN4JSProject)this.delegate.findProject(new N4JSProjectName(name)).orNull();
        if (project != null) {
            return new N4JSProjectConfig(this, project);
        }
        return null;
    }

    public IProjectConfig findProjectContaining(URI member) {
        IN4JSProject project = (IN4JSProject)this.delegate.findProject(member).orNull();
        if (project != null) {
            return new N4JSProjectConfig(this, project);
        }
        return null;
    }

    public Set<? extends IProjectConfig> getProjects() {
        HashSet<N4JSProjectConfig> pConfigs = new HashSet<N4JSProjectConfig>();
        for (IN4JSProject iN4JSProject : this.delegate.findAllProjects()) {
            pConfigs.add(new N4JSProjectConfig(this, iN4JSProject));
        }
        return pConfigs;
    }
}

