/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.IdentityHashMap;
import org.apache.felix.scr.impl.inject.ComponentMethods;
import org.apache.felix.scr.impl.inject.LifecycleMethod;
import org.apache.felix.scr.impl.inject.MethodResult;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.ComponentContainer;
import org.apache.felix.scr.impl.manager.ComponentContextImpl;
import org.apache.felix.scr.impl.manager.DependencyManager;
import org.apache.felix.scr.impl.manager.RefPair;
import org.apache.felix.scr.impl.manager.SingleComponentManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentInstance;

public class ServiceFactoryComponentManager<S>
extends SingleComponentManager<S> {
    private IdentityHashMap<S, ComponentContextImpl<S>> serviceContexts = new IdentityHashMap();

    @Override
    public void setServiceProperties(Dictionary<String, ?> serviceProperties) {
        throw new IllegalStateException("Bundle or instance scoped service properties are immutable");
    }

    @Override
    void postRegister() {
    }

    public ServiceFactoryComponentManager(ComponentContainer<S> container, ComponentMethods<S> componentMethods) {
        super(container, componentMethods);
    }

    @Override
    protected void deleteComponent(int reason) {
        if (!this.isStateLocked()) {
            throw new IllegalStateException("need write lock (deleteComponent)");
        }
        for (ComponentContextImpl<S> componentContext : this.getComponentContexts()) {
            this.disposeImplementationObject(componentContext, reason);
            this.getLogger().log(4, "Unset implementation object for component in deleteComponent for reason {0}", null, REASONS[reason]);
        }
        this.serviceContexts.clear();
        this.clearServiceProperties();
    }

    @Override
    public S getService(Bundle bundle, ServiceRegistration<S> serviceRegistration) {
        this.getLogger().log(4, "ServiceFactory.getService()", null);
        ComponentContextImpl<S> componentContext = new ComponentContextImpl<S>(this, bundle, serviceRegistration);
        if (!this.collectDependencies(componentContext)) {
            return null;
        }
        this.getLogger().log(4, "getService (ServiceFactory) dependencies collected.", null);
        AbstractComponentManager.State previousState = this.getState();
        S service = this.createImplementationObject(bundle, new SingleComponentManager.SetImplementationObject<S>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void presetComponentContext(ComponentContextImpl<S> componentContext) {
                IdentityHashMap identityHashMap = ServiceFactoryComponentManager.this.serviceContexts;
                synchronized (identityHashMap) {
                    ServiceFactoryComponentManager.this.serviceContexts.put(componentContext.getImplementationObject(false), componentContext);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetImplementationObject(S implementationObject) {
                IdentityHashMap identityHashMap = ServiceFactoryComponentManager.this.serviceContexts;
                synchronized (identityHashMap) {
                    ServiceFactoryComponentManager.this.serviceContexts.remove(implementationObject);
                }
            }
        }, componentContext);
        if (service == null) {
            this.getLogger().log(4, "Failed creating the component instance; see log for reason", null);
        } else {
            this.setState(previousState, AbstractComponentManager.State.active);
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ungetService(Bundle bundle, ServiceRegistration<S> registration, S service) {
        ComponentContextImpl<S> serviceContext;
        this.getLogger().log(4, "ServiceFactory.ungetService()", null);
        IdentityHashMap<S, ComponentContextImpl<S>> identityHashMap = this.serviceContexts;
        synchronized (identityHashMap) {
            serviceContext = this.serviceContexts.get(service);
        }
        this.disposeImplementationObject(serviceContext, 5);
        identityHashMap = this.serviceContexts;
        synchronized (identityHashMap) {
            AbstractComponentManager.State previousState;
            this.serviceContexts.remove(service);
            if (this.serviceContexts.isEmpty() && (previousState = this.getState()) == AbstractComponentManager.State.active) {
                this.setState(previousState, AbstractComponentManager.State.satisfied);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ComponentContextImpl<S>> getComponentContexts() {
        IdentityHashMap<S, ComponentContextImpl<S>> identityHashMap = this.serviceContexts;
        synchronized (identityHashMap) {
            return new ArrayList<ComponentContextImpl<S>>(this.serviceContexts.values());
        }
    }

    @Override
    <T> void invokeBindMethod(DependencyManager<S, T> dependencyManager, RefPair<S, T> refPair, int trackingCount) {
        for (ComponentContextImpl<S> cc : this.getComponentContexts()) {
            dependencyManager.invokeBindMethod(cc, refPair, trackingCount, cc.getEdgeInfo(dependencyManager));
        }
    }

    @Override
    <T> boolean invokeUpdatedMethod(DependencyManager<S, T> dependencyManager, RefPair<S, T> refPair, int trackingCount) {
        boolean reactivate = false;
        for (ComponentContextImpl<S> cc : this.getComponentContexts()) {
            if (!dependencyManager.invokeUpdatedMethod(cc, refPair, trackingCount, cc.getEdgeInfo(dependencyManager))) continue;
            reactivate = true;
        }
        return reactivate;
    }

    @Override
    <T> void invokeUnbindMethod(DependencyManager<S, T> dependencyManager, RefPair<S, T> oldRefPair, int trackingCount) {
        for (ComponentContextImpl<S> cc : this.getComponentContexts()) {
            dependencyManager.invokeUnbindMethod(cc, oldRefPair, trackingCount, cc.getEdgeInfo(dependencyManager));
        }
    }

    @Override
    protected MethodResult invokeModifiedMethod() {
        LifecycleMethod modifiedMethod = this.getComponentMethods().getModifiedMethod();
        MethodResult result = MethodResult.VOID;
        for (ComponentContextImpl<S> componentContext : this.getComponentContexts()) {
            S instance = componentContext.getImplementationObject(true);
            result = modifiedMethod.invoke(instance, componentContext, -1, MethodResult.VOID);
        }
        return result;
    }

    @Override
    boolean hasInstance() {
        return !this.serviceContexts.isEmpty();
    }

    @Override
    public ComponentInstance getComponentInstance() {
        return super.getComponentInstance();
    }
}

