/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.parameter;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.XpectInvocation;
import org.eclipse.xpect.XpectReplace;
import org.eclipse.xpect.expectation.impl.TargetSyntaxSupport;
import org.eclipse.xpect.parameter.IStatementRelatedRegion;
import org.eclipse.xpect.parameter.IntegerProvider;
import org.eclipse.xpect.parameter.IntegerRegion;
import org.eclipse.xpect.parameter.OffsetProvider;
import org.eclipse.xpect.parameter.OffsetRegion;
import org.eclipse.xpect.parameter.ParameterParser;
import org.eclipse.xpect.parameter.ParameterRegion;
import org.eclipse.xpect.parameter.StringProvider;
import org.eclipse.xpect.parameter.StringRegion;
import org.eclipse.xpect.runner.ArgumentContributor;
import org.eclipse.xpect.setup.XpectSetupFactory;
import org.eclipse.xpect.state.Configuration;
import org.eclipse.xpect.text.IRegion;
import org.eclipse.xpect.text.Region;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.formallang.FollowerFunction;
import org.eclipse.xtext.util.formallang.FollowerFunctionImpl;
import org.eclipse.xtext.util.formallang.Nfa;
import org.eclipse.xtext.util.formallang.NfaUtil;
import org.eclipse.xtext.util.formallang.Production;
import org.eclipse.xtext.util.formallang.ProductionUtil;
import org.eclipse.xtext.util.formallang.StringProduction;
import org.junit.ComparisonFailure;

@XpectSetupFactory
@XpectReplace(value={ArgumentContributor.class})
@XpectImport(value={StringProvider.class, IntegerProvider.class, OffsetProvider.class})
public class ParameterParserImpl
extends ArgumentContributor {
    protected static final Pattern WS = Pattern.compile("^[\\s]+");
    private final ParameterParser annotation;
    private final ParameterRegion parameterRegion;
    private final XpectInvocation statement;
    private final TargetSyntaxSupport syntax;

    public ParameterParserImpl(TargetSyntaxSupport syntax, XpectInvocation statement) {
        this.annotation = statement.getMethod().getJavaMethod().getAnnotation(ParameterParser.class);
        this.parameterRegion = statement.getRelatedRegion(ParameterRegion.class);
        this.statement = statement;
        this.syntax = syntax;
    }

    @Override
    public void contributeArguments(Configuration[] configurations) {
        if (this.annotation == null || Strings.isEmpty((String)this.annotation.syntax())) {
            return;
        }
        AssignedProduction syntax = new AssignedProduction(this.annotation.syntax());
        Map<String, IStatementRelatedRegion> parsed = this.parseParams(this.annotation.syntax(), syntax, this.statement, this.parameterRegion);
        Map<String, Token> defaults = this.getDefaults(syntax);
        int i = 0;
        while (i < configurations.length) {
            String key = "arg" + i;
            IStatementRelatedRegion value = parsed.get(key);
            if (value != null) {
                configurations[i].addDefaultValue(value);
            } else {
                Token token = defaults.get(key);
                if (token != null) {
                    IStatementRelatedRegion default1 = this.convertDefault(token);
                    configurations[i].addDefaultValue(default1);
                }
            }
            ++i;
        }
    }

    protected Map<String, Token> getDefaults(AssignedProduction syntax) {
        HashMap result = Maps.newHashMap();
        for (StringProduction.ProdElement ele : new ProductionUtil().getAllChildren((Production)syntax, (Object)syntax.getRoot())) {
            String name = ele.getName();
            if (Strings.isEmpty((String)name)) continue;
            result.put(name, Token.valueOf(ele.getValue()));
        }
        return result;
    }

    protected IStatementRelatedRegion convertDefault(Token token) {
        switch (token) {
            case OFFSET: {
                int offset = this.syntax.findFirstSemanticCharAfterStatement(this.statement);
                return new OffsetRegion(this.parameterRegion, offset);
            }
            case INT: {
                return new IntegerRegion(this.parameterRegion);
            }
            case ID: 
            case STRING: 
            case TEXT: {
                return new StringRegion(this.parameterRegion);
            }
        }
        throw new RuntimeException();
    }

    protected IStatementRelatedRegion convertValue(XpectInvocation invocation, Token token, IRegion claim, IRegion match) {
        switch (token) {
            case OFFSET: {
                return new OffsetRegion(this.parameterRegion, claim.getOffset() + match.getOffset(), match.getLength());
            }
            case INT: {
                return new IntegerRegion(this.parameterRegion, claim.getOffset() + match.getOffset(), match.getLength());
            }
            case ID: 
            case STRING: 
            case TEXT: {
                return new StringRegion(this.parameterRegion, claim.getOffset() + match.getOffset(), match.getLength());
            }
        }
        throw new RuntimeException();
    }

    public ParameterParser getAnnotation() {
        return this.annotation;
    }

    protected Nfa<StringProduction.ProdElement> getParameterNfa(AssignedProduction prod) {
        FollowerFunctionImpl ff = new FollowerFunctionImpl((Production)prod);
        AssignedProduction assignedProduction = prod;
        ((Object)((Object)assignedProduction)).getClass();
        StringProduction.ProdElement start = new StringProduction.ProdElement((StringProduction)assignedProduction, StringProduction.ElementType.TOKEN);
        AssignedProduction assignedProduction2 = prod;
        ((Object)((Object)assignedProduction2)).getClass();
        StringProduction.ProdElement stop = new StringProduction.ProdElement((StringProduction)assignedProduction2, StringProduction.ElementType.TOKEN);
        Nfa result = new NfaUtil().create((Production)prod, (FollowerFunction)ff, (Object)start, (Object)stop);
        return result;
    }

    protected Map<String, IStatementRelatedRegion> parseParams(String syntax, AssignedProduction production, XpectInvocation invocation, IRegion claim) {
        String document = invocation.getFile().getDocument();
        final String text = document.substring(claim.getOffset(), claim.getOffset() + claim.getLength());
        Nfa<StringProduction.ProdElement> nfa = this.getParameterNfa(production);
        Matcher ws = WS.matcher(text);
        List trace = new NfaUtil().backtrack(nfa, (Object)new BacktrackItem(ws.find() ? ws.end() : 0), (NfaUtil.BacktrackHandler)new NfaUtil.BacktrackHandler<StringProduction.ProdElement, BacktrackItem>(){

            public BacktrackItem handle(StringProduction.ProdElement state, BacktrackItem previous) {
                if (Strings.isEmpty((String)state.getValue())) {
                    return new BacktrackItem(previous.offset, state, new Region(text, previous.offset, 0));
                }
                if (Strings.isEmpty((String)state.getName())) {
                    if (text.regionMatches(previous.offset, state.getValue(), 0, state.getValue().length())) {
                        int newOffset = previous.offset + state.getValue().length();
                        Matcher ws = WS.matcher(text).region(newOffset, text.length());
                        int childOffset = ws.find() ? ws.end() : newOffset;
                        return new BacktrackItem(childOffset, state, new Region(text, previous.offset, state.getValue().length()));
                    }
                } else {
                    Token t = Token.valueOf(state.getValue());
                    Matcher matcher = t.pattern.matcher(text).region(previous.offset, text.length());
                    if (matcher.find()) {
                        int end;
                        int start;
                        int childOffset;
                        Matcher ws = WS.matcher(text).region(matcher.end(), text.length());
                        int n = childOffset = ws.find() ? ws.end() : matcher.end();
                        if (matcher.groupCount() > 0 && matcher.group(1) != null) {
                            start = matcher.start(1);
                            end = matcher.end(1);
                        } else {
                            start = matcher.start(0);
                            end = matcher.end(0);
                        }
                        return new BacktrackItem(childOffset, state, new Region(text, start, end - start));
                    }
                }
                return null;
            }

            public boolean isSolution(BacktrackItem result) {
                return true;
            }

            public Iterable<StringProduction.ProdElement> sortFollowers(BacktrackItem result, Iterable<StringProduction.ProdElement> followers) {
                return followers;
            }
        });
        HashMap result = Maps.newHashMap();
        String trimmed = text.trim();
        if (trace != null && !trace.isEmpty()) {
            String trailing;
            IRegion last = ((BacktrackItem)trace.get((int)(trace.size() - 1))).region;
            int end = last.getOffset() + last.getLength();
            if (end < claim.getLength() && !(trailing = text.substring(end).trim()).isEmpty()) {
                this.errorLeftoverTrailingText(claim, end, trailing, syntax);
            }
            for (BacktrackItem item : trace) {
                if (item.token == null || item.token.getName() == null) continue;
                String key = item.token.getName();
                Token token = Token.valueOf(item.token.getValue());
                result.put(key, this.convertValue(invocation, token, claim, item.region));
            }
            return result;
        }
        if (trimmed.isEmpty()) {
            throw new RuntimeException("Parameters that match syntax \"" + syntax + "\" are required, but have not been provided.");
        }
        throw new RuntimeException("could not parse \"" + trimmed + "\" with grammar \"" + syntax + "\"");
    }

    protected void errorLeftoverTrailingText(IRegion claim, int offset, String leftover, String syntax) {
        String expected = claim.getDocument().toString();
        String actual = String.valueOf(expected.substring(0, claim.getOffset() + offset)) + expected.substring(claim.getOffset() + claim.getLength());
        String text = claim.getRegionText().trim();
        String msg = "When parsing \"" + text + "\" with syntax \"" + syntax + "\", the trailing part \"" + leftover + "\" remains unmatched.";
        throw new ComparisonFailure(msg, expected, actual);
    }

    public static class AssignedProduction
    extends StringProduction {
        public AssignedProduction(String production) {
            super(production);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected StringProduction.ProdElement parsePrim(Stack<Pair<StringProduction.Token, String>> tokens) {
            Pair<StringProduction.Token, String> current = tokens.pop();
            switch ((StringProduction.Token)current.getFirst()) {
                case PL: {
                    StringProduction.ProdElement result1 = this.parseAlt(tokens);
                    if (!((StringProduction.Token)tokens.peek().getFirst()).equals((Object)StringProduction.Token.PR)) {
                        throw new RuntimeException("')' expected, but " + tokens.peek().getFirst() + " found");
                    }
                    tokens.pop();
                    this.parseCardinality(tokens, result1);
                    return result1;
                }
                case STRING: {
                    StringProduction.ProdElement result2 = this.createElement(StringProduction.ElementType.TOKEN);
                    result2.setValue((String)current.getSecond());
                    this.parseCardinality(tokens, result2);
                    return result2;
                }
                case ID: {
                    StringProduction.ProdElement result3 = this.createElement(StringProduction.ElementType.TOKEN);
                    result3.setName((String)current.getSecond());
                    Pair<StringProduction.Token, String> eq = tokens.pop();
                    if (eq.getFirst() != StringProduction.Token.EQ) throw new RuntimeException("Unexpected token " + eq.getFirst() + ", expected '='");
                    Pair<StringProduction.Token, String> val = tokens.pop();
                    switch ((StringProduction.Token)val.getFirst()) {
                        case ID: 
                        case STRING: {
                            result3.setValue((String)val.getSecond());
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unexpected token " + current.getFirst());
                        }
                    }
                    this.parseCardinality(tokens, result3);
                    return result3;
                }
            }
            throw new RuntimeException("Unexpected token " + current.getFirst());
        }
    }

    protected static class BacktrackItem {
        protected int offset;
        protected IRegion region;
        protected StringProduction.ProdElement token;

        public BacktrackItem(int offset) {
            this.offset = offset;
        }

        public BacktrackItem(int offset, StringProduction.ProdElement token, IRegion region) {
            this.offset = offset;
            this.token = token;
            this.region = region;
        }

        public String toString() {
            return this.token + ":" + this.region;
        }
    }

    public static enum Token {
        ID("[a-zA-Z][a-zA-Z0-9_]*"),
        INT("[0-9]+"),
        OFFSET("'([^']*)'|[^\\s]+"),
        STRING("'([^']*)'"),
        TEXT("[^\\s]+");

        public final Pattern pattern;

        private Token(String regex) {
            this.pattern = Pattern.compile("^" + regex);
        }
    }
}

