/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.building;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.ts.scoping.builtin.N4Scheme;

abstract class N4JSResourceSetCleanerUtils {
    private static final Logger LOGGER = Logger.getLogger(N4JSResourceSetCleanerUtils.class);

    N4JSResourceSetCleanerUtils() {
    }

    static void clearResourceSet(ResourceSet resourceSet) {
        boolean wasDeliver = resourceSet.eDeliver();
        try {
            resourceSet.eSetDeliver(false);
            EList resources = resourceSet.getResources();
            int i = resources.size() - 1;
            while (i >= 0) {
                Resource resource = (Resource)resources.get(i);
                URI uri = resource.getURI();
                if (!N4Scheme.isN4Scheme((URI)uri)) {
                    resources.remove(i);
                } else {
                    LOGGER.info((Object)("Intentionally skipping the removal of N4 resource: " + uri));
                }
                --i;
            }
        }
        finally {
            resourceSet.eSetDeliver(wasDeliver);
        }
    }
}

