/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.factories;

import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.factories.ASTUtils;
import org.eclipse.n4js.flowgraphs.factories.DelegatingNodeFactory;
import org.eclipse.n4js.flowgraphs.factories.ReentrantASTIterator;
import org.eclipse.n4js.flowgraphs.model.CatchToken;
import org.eclipse.n4js.flowgraphs.model.ComplexNode;
import org.eclipse.n4js.flowgraphs.model.HelperNode;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.LabelledStatement;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.WhileStatement;

class WhileFactory {
    WhileFactory() {
    }

    static ComplexNode buildComplexNode(ReentrantASTIterator astpp, WhileStatement whileStmt) {
        ComplexNode cNode = new ComplexNode(astpp.container(), (ControlFlowElement)whileStmt);
        HelperNode entryNode = new HelperNode("entry", astpp.pos(), (ControlFlowElement)whileStmt);
        Node conditionNode = DelegatingNodeFactory.createOrHelper(astpp, "condition", (ControlFlowElement)whileStmt, (ControlFlowElement)whileStmt.getExpression());
        HelperNode conditionForkNode = new HelperNode("conditionFork", astpp.pos(), (ControlFlowElement)whileStmt);
        Node bodyNode = DelegatingNodeFactory.createOrHelper(astpp, "body", (ControlFlowElement)whileStmt, (ControlFlowElement)whileStmt.getStatement());
        HelperNode continueCatchNode = new HelperNode("continueCatch", astpp.pos(), (ControlFlowElement)whileStmt);
        HelperNode exitNode = new HelperNode("exit", astpp.pos(), (ControlFlowElement)whileStmt);
        cNode.addNode(entryNode);
        cNode.addNode(conditionNode);
        cNode.addNode(conditionForkNode);
        cNode.addNode(bodyNode);
        cNode.addNode(continueCatchNode);
        cNode.addNode(exitNode);
        cNode.connectInternalSucc(entryNode, conditionNode, conditionForkNode);
        cNode.connectInternalSucc(ControlFlowType.LoopEnter, conditionForkNode, bodyNode);
        cNode.connectInternalSucc(ControlFlowType.LoopExit, conditionForkNode, exitNode);
        cNode.connectInternalSucc(bodyNode, continueCatchNode);
        cNode.connectInternalSucc(ControlFlowType.LoopRepeat, continueCatchNode, conditionNode);
        cNode.setEntryNode(entryNode);
        cNode.setExitNode(exitNode);
        bodyNode.addCatchToken(new CatchToken(ControlFlowType.IfTrue, ControlFlowType.LoopEnter));
        exitNode.addCatchToken(new CatchToken(ControlFlowType.IfFalse, ControlFlowType.LoopExit));
        LabelledStatement lblStmt = ASTUtils.getLabelledStatement((Statement)whileStmt);
        exitNode.addCatchToken(new CatchToken(ControlFlowType.Break, lblStmt));
        continueCatchNode.addCatchToken(new CatchToken(ControlFlowType.Continue, lblStmt));
        return cNode;
    }
}

